/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.eurekaservice.client.impl;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.zowe.apiml.eurekaservice.client.config.ApiMediationServiceConfig;
import org.zowe.apiml.eurekaservice.client.impl.ZUtil;
import org.zowe.apiml.eurekaservice.client.impl.ZUtilDummy;
import org.zowe.apiml.util.ClassOrDefaultProxyUtils;

public class DefaultCustomMetadataHelper {
    private static final String ZOS_JOB_ID = "zos.jobid";
    private static final String ZOS_JOB_NAME = "zos.jobname";
    private static final String ZOS_USER_ID = "zos.userid";
    private static final String ZOS_PID = "zos.pid";
    private static final String ZOS_SYSNAME = "zos.sysname";
    private static final String ZOS_SYSCLONE = "zos.sysclone";
    private static final String ZOS_SYSPLEX = "zos.sysplex";
    private static final String OS_NAME = "os.name";
    private ZUtil zUtil = this.isRunningOnZos() ? (ZUtil)ClassOrDefaultProxyUtils.createProxy(ZUtil.class, (String)"com.ibm.jzos.ZUtil", ZUtilDummy::new, (ClassOrDefaultProxyUtils.ExceptionMapping[])new ClassOrDefaultProxyUtils.ExceptionMapping[0]) : new ZUtilDummy();

    protected boolean isRunningOnZos() {
        return "z/OS".equals(System.getProperty(OS_NAME));
    }

    private Map<String, Object> getDefaultCustomMetadata() {
        HashMap<String, Object> output = new HashMap<String, Object>();
        output.put(OS_NAME, System.getProperty(OS_NAME));
        if (this.isRunningOnZos()) {
            output.put(ZOS_JOB_ID, this.zUtil.getCurrentJobId());
            output.put(ZOS_JOB_NAME, this.zUtil.getCurrentJobname());
            output.put(ZOS_USER_ID, this.zUtil.getCurrentUser());
            output.put(ZOS_PID, this.zUtil.getPid());
            output.put(ZOS_SYSNAME, this.zUtil.substituteSystemSymbols("&SYSNAME."));
            output.put(ZOS_SYSCLONE, this.zUtil.substituteSystemSymbols("&SYSCLONE."));
            output.put(ZOS_SYSPLEX, this.zUtil.substituteSystemSymbols("&SYSPLEX."));
        }
        return output;
    }

    public void update(ApiMediationServiceConfig config) {
        if (config.getCustomMetadata() == null) {
            config.setCustomMetadata(new HashMap<String, Object>());
        }
        this.update(config.getCustomMetadata());
    }

    public void update(Map<String, Object> customMetadata) {
        Map<String, Object> defaultMetadata = this.getDefaultCustomMetadata();
        for (Map.Entry<String, Object> entry : defaultMetadata.entrySet()) {
            customMetadata.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    @Generated
    protected void setZUtil(ZUtil zUtil) {
        this.zUtil = zUtil;
    }
}

