/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class ZosmfRenameRequest {
    private static final String REQUEST_TYPE = "rename";
    private String dsn;
    private String member;

    private ZosmfRenameRequest(String dsn, String member) {
        this.dsn = dsn;
        this.member = member;
    }

    public static ZosmfRenameRequest createFromDataSetRenameRequest(String name) {
        String member;
        String dsn;
        if (ZosmfRenameRequest.hasMember(name)) {
            dsn = ZosmfRenameRequest.parseDsn(name);
            member = ZosmfRenameRequest.parseMember(name);
        } else {
            dsn = name;
            member = "";
        }
        return new ZosmfRenameRequest(dsn, member);
    }

    public String getDsn() {
        return this.dsn;
    }

    public String getMember() {
        return this.member;
    }

    private static String parseDsn(String name) {
        return name.substring(0, name.indexOf(40));
    }

    private static String parseMember(String name) {
        return name.substring(name.indexOf(40) + 1, name.indexOf(41));
    }

    private static boolean hasMember(String name) {
        return name.contains("(") && name.contains(")");
    }

    public JsonObject buildJson() {
        JsonObject renameJObj = new JsonObject();
        JsonObject fromJObj = new JsonObject();
        fromJObj.addProperty("dsn", this.dsn);
        if (!this.member.isEmpty()) {
            fromJObj.addProperty("member", this.member);
        }
        renameJObj.addProperty("request", REQUEST_TYPE);
        renameJObj.add("from-dataset", (JsonElement)fromJObj);
        return renameJObj;
    }

    public String toString() {
        return this.buildJson().toString();
    }
}

