/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.services.zosmf;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.methods.RequestBuilder;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.connectors.zosmf.exceptions.DataSetNotFoundException;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.data.sets.services.zosmf.AbstractZosmfDataSetsRequestRunner;

public class DeleteDataSetZosmfRequestRunner
extends AbstractZosmfDataSetsRequestRunner<Void> {
    private String dataSetName;

    public DeleteDataSetZosmfRequestRunner(String dataSetName, List<Header> headers) {
        super(headers);
        this.dataSetName = dataSetName;
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException, IOException {
        URI requestUrl = zosmfConnector.getFullUrl(String.format("restfiles/ds/%s", this.dataSetName));
        return RequestBuilder.delete((URI)requestUrl);
    }

    protected int[] getSuccessStatus() {
        return new int[]{204};
    }

    protected Void getResult(ResponseCache responseCache) throws IOException {
        return null;
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        JsonElement details = jsonResponse.get("details");
        if (statusCode == 404 && details.toString().contains(String.format("ISRZ002 Data set not cataloged - '%s' was not found in catalog.", this.dataSetName))) {
            throw new DataSetNotFoundException(this.dataSetName);
        }
        return null;
    }
}

