/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.services;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.zowe.api.common.model.ItemsWrapper;
import org.zowe.data.sets.model.DataSet;
import org.zowe.data.sets.model.DataSetAttributes;
import org.zowe.data.sets.model.DataSetContentWithEtag;
import org.zowe.data.sets.model.DataSetCreateRequest;
import org.zowe.data.sets.model.DataSetRenameRequest;

public abstract class DataSetService {
    private HttpServletRequest request;

    public List<Header> getIbmHeadersFromRequest() {
        ArrayList<Header> ibmHeaders = new ArrayList<Header>();
        if (this.request != null) {
            Enumeration headerNames = this.request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = ((String)headerNames.nextElement()).toUpperCase();
                if (!headerName.contains("X-IBM")) continue;
                BasicHeader newHeader = new BasicHeader(headerName, this.request.getHeader(headerName));
                ibmHeaders.add((Header)newHeader);
            }
        }
        return ibmHeaders;
    }

    public abstract ItemsWrapper<DataSetAttributes> listDataSetAttributes(String var1);

    public abstract ItemsWrapper<DataSet> listDataSets(String var1);

    public abstract ItemsWrapper<String> listDataSetMembers(String var1);

    public abstract DataSetContentWithEtag getContent(String var1);

    public abstract String putContent(String var1, DataSetContentWithEtag var2);

    public abstract String createDataSet(DataSetCreateRequest var1);

    public abstract void deleteDataSet(String var1);

    public abstract String renameDataSet(String var1, DataSetRenameRequest var2);

    @Generated
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

