/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.services.zosmf;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.http.Header;
import org.zowe.api.common.connectors.zosmf.exceptions.DataSetNotFoundException;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.zosmf.services.AbstractZosmfRequestRunner;
import org.zowe.data.sets.exceptions.DataSetLockedException;
import org.zowe.data.sets.exceptions.UnauthorisedDataSetException;

public abstract class AbstractZosmfDataSetsRequestRunner<T>
extends AbstractZosmfRequestRunner<T> {
    private static final String AUTHORIZATION_FAILURE = "ISRZ002 Authorization failed";
    private static final String DATA_SET_NOT_FOUND = "ISRZ002 Data set not cataloged";

    public AbstractZosmfDataSetsRequestRunner(List<Header> headers) {
        super(headers);
    }

    ZoweApiRestException createDataSetException(JsonObject jsonResponse, int statusCode, String dataSetName) {
        JsonElement details = jsonResponse.get("details");
        if (statusCode == 500 && details != null) {
            if (details.toString().contains(AUTHORIZATION_FAILURE)) {
                throw new UnauthorisedDataSetException(dataSetName);
            }
            if (details.toString().contains("IEFA110I")) {
                JsonArray array = details.getAsJsonArray();
                String[] dataLine = array.get(array.size() - 1).getAsString().split("\\s+");
                throw new DataSetLockedException(dataSetName, dataLine[0], dataLine[1], dataLine[2]);
            }
        } else if (statusCode == 404 && details != null && details.toString().contains(DATA_SET_NOT_FOUND)) {
            throw new DataSetNotFoundException(dataSetName);
        }
        return null;
    }
}

