/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.unix.files.services.zosmf;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.unix.files.exceptions.AlreadyExistsException;
import org.zowe.unix.files.exceptions.InvalidPermissionsException;
import org.zowe.unix.files.model.UnixCreateAssetRequest;
import org.zowe.unix.files.model.UnixEntityType;
import org.zowe.unix.files.services.zosmf.AbstractZosmfUnixFilesRequestRunner;

public class CreateUnixAssetZosmfRunner
extends AbstractZosmfUnixFilesRequestRunner<String> {
    private UnixCreateAssetRequest request;
    private String path;

    public CreateUnixAssetZosmfRunner(String name, UnixCreateAssetRequest request, List<Header> headers) {
        super(headers);
        this.request = request;
        this.path = name;
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException, IOException {
        URI requestUrl = zosmfConnector.getFullUrl("restfiles/fs" + this.path);
        JsonObject requestBody = this.getZosmfRequestJson();
        StringEntity requestEntity = new StringEntity(requestBody.toString(), ContentType.APPLICATION_JSON);
        RequestBuilder requestBuilder = RequestBuilder.post((URI)requestUrl).setEntity((HttpEntity)requestEntity);
        return requestBuilder;
    }

    private JsonObject getZosmfRequestJson() {
        JsonObject zosmfRequestJson = new JsonObject();
        if (this.request.getType() == UnixEntityType.DIRECTORY) {
            zosmfRequestJson.addProperty("type", "directory");
        } else if (this.request.getType() == UnixEntityType.FILE) {
            zosmfRequestJson.addProperty("type", "file");
        }
        if (this.request.getPermissions() != null) {
            this.validatePermissionsString(this.request.getPermissions());
            zosmfRequestJson.addProperty("mode", this.request.getPermissions());
        }
        return zosmfRequestJson;
    }

    private void validatePermissionsString(String permissions) {
        String validPattern = "((r|R|-)(w|W|-)(x|X|-)){3}";
        Pattern pattern = Pattern.compile(validPattern);
        Matcher matcher = pattern.matcher(permissions);
        if (!matcher.matches() || permissions.length() > 9) {
            throw new InvalidPermissionsException(permissions);
        }
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        String details;
        String message = jsonResponse.get("message").getAsString();
        if (message.contains("already exists")) {
            throw new AlreadyExistsException(this.path);
        }
        if (message.contains("mode") && (details = jsonResponse.get("details").getAsString()).contains(this.request.getPermissions())) {
            throw new InvalidPermissionsException(this.request.getPermissions());
        }
        return null;
    }

    protected int[] getSuccessStatus() {
        return new int[]{201};
    }

    protected String getResult(ResponseCache responseCache) throws IOException {
        return this.path;
    }
}

