/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.unix.files.services.zosmf;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.methods.RequestBuilder;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.unix.files.exceptions.NotAnEmptyDirectoryException;
import org.zowe.unix.files.services.zosmf.AbstractZosmfUnixFilesRequestRunner;

public class DeleteUnixFileZosmfRunner
extends AbstractZosmfUnixFilesRequestRunner<Void> {
    private String path;
    private boolean isRecursive;

    public DeleteUnixFileZosmfRunner(String path, boolean isRecursive, List<Header> headers) {
        super(headers);
        this.path = path;
        this.isRecursive = isRecursive;
    }

    public DeleteUnixFileZosmfRunner(String path, List<Header> headers) {
        this(path, false, headers);
    }

    protected int[] getSuccessStatus() {
        return new int[]{204};
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException, IOException {
        URI requestUrl = zosmfConnector.getFullUrl("restfiles/fs" + this.path);
        RequestBuilder requestBuilder = RequestBuilder.delete((URI)requestUrl);
        if (this.isRecursive) {
            requestBuilder.addHeader("X-IBM-Option", "recursive");
        }
        return requestBuilder;
    }

    protected Void getResult(ResponseCache responseCache) throws IOException {
        return null;
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        JsonElement details = jsonResponse.get("details");
        if (null != details) {
            if (details.toString().contains("EDC5136I Directory not empty.")) {
                throw new NotAnEmptyDirectoryException(this.path);
            }
            return this.createUnixFileException(jsonResponse, statusCode, this.path);
        }
        return null;
    }
}

