/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.services.zosmf;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.springframework.http.HttpStatus;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.errors.ApiError;
import org.zowe.api.common.exceptions.ZoweApiErrorException;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.data.sets.model.DataSetRenameRequest;
import org.zowe.data.sets.model.ZosmfRenameRequest;
import org.zowe.data.sets.services.zosmf.AbstractZosmfDataSetsRequestRunner;

public class PutDataSetRenameZosmfRequestRunner
extends AbstractZosmfDataSetsRequestRunner<String> {
    private DataSetRenameRequest request;
    private String oldDataSetName;

    public PutDataSetRenameZosmfRequestRunner(String oldDataSetName, DataSetRenameRequest request, List<Header> headers) {
        super(headers);
        this.oldDataSetName = oldDataSetName;
        this.request = request;
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException, IOException {
        String urlPath = String.format("restfiles/ds/%s", this.request.getNewName());
        URI requestUrl = zosmfConnector.getFullUrl(urlPath);
        JsonObject requestBody = this.convertIntoZosmfRequestJson(this.oldDataSetName);
        StringEntity requestEntity = new StringEntity(requestBody.toString(), ContentType.APPLICATION_JSON);
        return RequestBuilder.put((URI)requestUrl).setEntity((HttpEntity)requestEntity);
    }

    protected int[] getSuccessStatus() {
        return new int[]{200, 201, 204};
    }

    protected String getResult(ResponseCache responseCache) throws IOException {
        return responseCache.getEntity();
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        JsonElement details = jsonResponse.get("details");
        JsonElement stack = jsonResponse.get("stack");
        if (details != null) {
            if (details.getAsString().contains("not found")) {
                String errorMessage = details.getAsString();
                ApiError expectedError = ApiError.builder().message(errorMessage).status(HttpStatus.NOT_FOUND).build();
                throw new ZoweApiErrorException(expectedError);
            }
            String errorMessage = details.getAsString();
            ApiError expectedError = ApiError.builder().message(errorMessage).status(HttpStatus.BAD_REQUEST).build();
            throw new ZoweApiErrorException(expectedError);
        }
        if (stack != null && stack.getAsString().contains("parse")) {
            String errorMessage = String.format("Rename request of dataset %s failed because of invalid name %s", this.oldDataSetName, this.request.getNewName());
            ApiError expectedError = ApiError.builder().message(errorMessage).status(HttpStatus.BAD_REQUEST).build();
            throw new ZoweApiErrorException(expectedError);
        }
        return this.createDataSetException(jsonResponse, statusCode, this.oldDataSetName);
    }

    private JsonObject convertIntoZosmfRequestJson(String name) {
        ZosmfRenameRequest renameRequest = ZosmfRenameRequest.createFromDataSetRenameRequest((String)name);
        return renameRequest.buildJson();
    }
}

