/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.services.zosmf;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.methods.RequestBuilder;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.data.sets.services.zosmf.AbstractZosmfDataSetsRequestRunner;

public abstract class AbstractListDataSetsZosmfRequestRunner<T>
extends AbstractZosmfDataSetsRequestRunner<T> {
    protected String filter;

    public AbstractListDataSetsZosmfRequestRunner(String filter, List<Header> headers) {
        super(headers);
        this.filter = filter;
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException, IOException {
        String query = String.format("dslevel=%s", this.filter);
        URI requestUrl = zosmfConnector.getFullUrl("restfiles/ds", query);
        RequestBuilder requestBuilder = RequestBuilder.get((URI)requestUrl);
        this.addHeaders(requestBuilder);
        return requestBuilder;
    }

    protected abstract void addHeaders(RequestBuilder var1);

    protected int[] getSuccessStatus() {
        return new int[]{200};
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        return this.createDataSetException(jsonResponse, statusCode, this.filter);
    }

    protected T getResult(ResponseCache responseCache) throws IOException {
        JsonObject response = responseCache.getEntityAsJsonObject();
        JsonElement items = response.get("items");
        return this.retrieveItems(items);
    }

    protected abstract T retrieveItems(JsonElement var1);
}

