/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.services.zosmf;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.springframework.util.StringUtils;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.connectors.zosmf.exceptions.DataSetNotFoundException;
import org.zowe.api.common.exceptions.PreconditionFailedException;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.data.sets.model.DataSetContent;
import org.zowe.data.sets.model.DataSetContentWithEtag;
import org.zowe.data.sets.services.zosmf.AbstractZosmfDataSetsRequestRunner;

public class PutDataSetContentZosmfRequestRunner
extends AbstractZosmfDataSetsRequestRunner<String> {
    private String dataSetName;
    private DataSetContentWithEtag contentWithEtag;

    public PutDataSetContentZosmfRequestRunner(String dataSetName, DataSetContentWithEtag contentWithEtag, List<Header> headers) {
        super(headers);
        this.dataSetName = dataSetName;
        this.contentWithEtag = contentWithEtag;
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException, IOException {
        String urlPath = String.format("restfiles/ds/%s", this.dataSetName);
        URI requestUrl = zosmfConnector.getFullUrl(urlPath);
        DataSetContent content = this.contentWithEtag.getContent();
        StringEntity requestEntity = new StringEntity(content.getRecords());
        RequestBuilder requestBuilder = RequestBuilder.put((URI)requestUrl).setEntity((HttpEntity)requestEntity);
        requestBuilder.addHeader("Content-type", ContentType.TEXT_PLAIN.getMimeType());
        String ifMatch = this.contentWithEtag.getEtag();
        if (StringUtils.hasText((String)ifMatch)) {
            requestBuilder.addHeader("If-Match", ifMatch.replaceAll("\"", ""));
        }
        return requestBuilder;
    }

    protected int[] getSuccessStatus() {
        return new int[]{201, 204};
    }

    protected String getResult(ResponseCache responseCache) throws IOException {
        return responseCache.getFirstHeader("ETag").getValue();
    }

    protected ZoweApiRestException createGeneralException(ResponseCache responseCache, URI uri) throws IOException {
        if (responseCache.getStatus() == 412) {
            return new PreconditionFailedException(this.dataSetName);
        }
        return super.createGeneralException(responseCache, uri);
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        String zosmfMessage = jsonResponse.get("message").getAsString();
        if ("Data set not found.".equals(zosmfMessage)) {
            throw new DataSetNotFoundException(this.dataSetName);
        }
        return this.createDataSetException(jsonResponse, statusCode, this.dataSetName);
    }
}

