/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.services.zosmf;

import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.model.ItemsWrapper;
import org.zowe.data.sets.model.DataSet;
import org.zowe.data.sets.model.DataSetAttributes;
import org.zowe.data.sets.model.DataSetContentWithEtag;
import org.zowe.data.sets.model.DataSetCreateRequest;
import org.zowe.data.sets.model.DataSetRenameRequest;
import org.zowe.data.sets.services.DataSetService;
import org.zowe.data.sets.services.zosmf.CreateDataSetZosmfRequestRunner;
import org.zowe.data.sets.services.zosmf.DeleteDataSetZosmfRequestRunner;
import org.zowe.data.sets.services.zosmf.GetDataSetContentZosmfRequestRunner;
import org.zowe.data.sets.services.zosmf.ListDataSetMembersZosmfRequestRunner;
import org.zowe.data.sets.services.zosmf.ListDataSetsAttributesZosmfRequestRunner;
import org.zowe.data.sets.services.zosmf.ListDataSetsZosmfRequestRunner;
import org.zowe.data.sets.services.zosmf.PutDataSetContentZosmfRequestRunner;
import org.zowe.data.sets.services.zosmf.PutDataSetRenameZosmfRequestRunner;

public abstract class AbstractZosmfDataSetService
extends DataSetService {
    abstract ZosmfConnector getZosmfConnector();

    @Override
    public ItemsWrapper<String> listDataSetMembers(String dataSetName) {
        ListDataSetMembersZosmfRequestRunner runner = new ListDataSetMembersZosmfRequestRunner(dataSetName, this.getIbmHeadersFromRequest());
        return (ItemsWrapper)runner.run(this.getZosmfConnector());
    }

    @Override
    public ItemsWrapper<DataSetAttributes> listDataSetAttributes(String filter) {
        ListDataSetsAttributesZosmfRequestRunner runner = new ListDataSetsAttributesZosmfRequestRunner(filter, this.getIbmHeadersFromRequest());
        return (ItemsWrapper)runner.run(this.getZosmfConnector());
    }

    @Override
    public ItemsWrapper<DataSet> listDataSets(String filter) {
        ListDataSetsZosmfRequestRunner runner = new ListDataSetsZosmfRequestRunner(filter, this.getIbmHeadersFromRequest());
        return (ItemsWrapper)runner.run(this.getZosmfConnector());
    }

    @Override
    public DataSetContentWithEtag getContent(String dataSetName) {
        GetDataSetContentZosmfRequestRunner runner = new GetDataSetContentZosmfRequestRunner(dataSetName, this.getIbmHeadersFromRequest());
        return (DataSetContentWithEtag)runner.run(this.getZosmfConnector());
    }

    @Override
    public String putContent(String dataSetName, DataSetContentWithEtag contentWithEtag) {
        PutDataSetContentZosmfRequestRunner runner = new PutDataSetContentZosmfRequestRunner(dataSetName, contentWithEtag, this.getIbmHeadersFromRequest());
        return (String)runner.run(this.getZosmfConnector());
    }

    @Override
    public String renameDataSet(String oldDataSetName, DataSetRenameRequest input) {
        PutDataSetRenameZosmfRequestRunner runner = new PutDataSetRenameZosmfRequestRunner(oldDataSetName, input, this.getIbmHeadersFromRequest());
        return (String)runner.run(this.getZosmfConnector());
    }

    @Override
    public String createDataSet(DataSetCreateRequest request) {
        CreateDataSetZosmfRequestRunner runner = new CreateDataSetZosmfRequestRunner(request, this.getIbmHeadersFromRequest());
        return (String)runner.run(this.getZosmfConnector());
    }

    @Override
    public void deleteDataSet(String dataSetName) {
        DeleteDataSetZosmfRequestRunner runner = new DeleteDataSetZosmfRequestRunner(dataSetName, this.getIbmHeadersFromRequest());
        runner.run(this.getZosmfConnector());
    }
}

