/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.services.zosmf;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.methods.RequestBuilder;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.model.ItemsWrapper;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.data.sets.services.zosmf.AbstractZosmfDataSetsRequestRunner;

public class ListDataSetMembersZosmfRequestRunner
extends AbstractZosmfDataSetsRequestRunner<ItemsWrapper<String>> {
    private String dataSetName;

    public ListDataSetMembersZosmfRequestRunner(String dataSetName, List<Header> headers) {
        super(headers);
        this.dataSetName = dataSetName;
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException, IOException {
        String urlPath = String.format("restfiles/ds/%s/member", this.dataSetName);
        URI requestUrl = zosmfConnector.getFullUrl(urlPath);
        return RequestBuilder.get((URI)requestUrl);
    }

    protected int[] getSuccessStatus() {
        return new int[]{200};
    }

    protected ItemsWrapper<String> getResult(ResponseCache responseCache) throws IOException {
        ArrayList<String> memberNames = new ArrayList<String>();
        JsonObject memberResponse = responseCache.getEntityAsJsonObject();
        JsonElement memberJsonArray = memberResponse.get("items");
        for (JsonElement jsonElement : memberJsonArray.getAsJsonArray()) {
            memberNames.add(jsonElement.getAsJsonObject().get("member").getAsString());
        }
        return new ItemsWrapper(memberNames);
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        return this.createDataSetException(jsonResponse, statusCode, this.dataSetName);
    }
}

