/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.api.common.exceptions;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import org.zowe.api.common.errors.ApiError;
import org.zowe.api.common.exceptions.InvalidFieldException;
import org.zowe.api.common.exceptions.InvalidObjectException;
import org.zowe.api.common.exceptions.ServerErrorException;
import org.zowe.api.common.exceptions.ZoweApiRestException;

@ControllerAdvice
public class ZoweRestExceptionHandler
extends ResponseEntityExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZoweRestExceptionHandler.class);

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException e, HttpHeaders headers, HttpStatus status, WebRequest request) {
        log.error("handleMethodArgumentNotValid", (Throwable)e);
        return this.handleBindException((Exception)e, e.getBindingResult(), headers, status, request);
    }

    protected ResponseEntity<Object> handleBindException(BindException e, HttpHeaders headers, HttpStatus status, WebRequest request) {
        log.error("handleMethodArgumentNotValid", (Throwable)e);
        return this.handleBindException((Exception)e, (BindingResult)e, headers, status, request);
    }

    private ResponseEntity<Object> handleBindException(Exception ex, BindingResult result, HttpHeaders headers, HttpStatus status, WebRequest request) {
        if (result.getFieldErrorCount() > 0) {
            return this.handleZoweException(new InvalidFieldException(result.getFieldError()), request);
        }
        if (result.getGlobalErrorCount() > 0) {
            return this.handleZoweException(new InvalidObjectException(result.getGlobalError()), request);
        }
        throw new ServerErrorException(ex);
    }

    @ExceptionHandler(value={ZoweApiRestException.class})
    public ResponseEntity<Object> handleZoweException(ZoweApiRestException ex, WebRequest request) {
        ApiError apiError = ex.getApiError();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        return this.handleExceptionInternal(ex, apiError, headers, apiError.getStatus(), request);
    }
}

