/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.api.common.connectors.zosmf;

import java.util.Arrays;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.zowe.api.common.connectors.zosmf.ConnectionProperties;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.NoAuthTokenException;

@Service
public class ZosmfConnectorJWTAuth
extends ZosmfConnector {
    @Autowired
    private HttpServletRequest request;

    @Autowired
    public ZosmfConnectorJWTAuth(ConnectionProperties properties) {
        super(properties);
    }

    @Override
    public Header getAuthHeader() {
        String cookieHeader = this.request.getHeader("cookie");
        if (cookieHeader != null && !cookieHeader.isEmpty()) {
            String[] cookies = cookieHeader.split(";");
            Optional<String> authTokenCookie = Arrays.stream(cookies).filter(c -> c.contains("apimlAuthenticationToken")).findFirst();
            if (authTokenCookie.isPresent()) {
                return new BasicHeader("Authorization", "Bearer " + authTokenCookie.get().split("=")[1]);
            }
        } else {
            String header = this.request.getHeader("authorization");
            if (header != null && !header.isEmpty()) {
                return new BasicHeader("Authorization", header);
            }
        }
        throw new NoAuthTokenException();
    }
}

