/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.api.common.test;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.http.Header;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.zowe.api.common.errors.ApiError;
import org.zowe.api.common.exceptions.ZoweApiRestException;

public abstract class AbstractHttpIntegrationTest {
    private static final String SERVER_HOST = System.getProperty("server.host");
    private static final String SERVER_PORT = System.getProperty("server.port");
    private static final String GATEWAY_HOST = System.getProperty("gateway.host");
    private static final String GATEWAY_PORT = System.getProperty("gateway.port");
    protected static final String BASE_URL = AbstractHttpIntegrationTest.getBaseUrl();
    protected static final String USER = System.getProperty("server.username");
    private static final String PASSWORD = System.getProperty("server.password");
    protected static final Header AUTH_HEADER = AbstractHttpIntegrationTest.getAuthHeader();

    private static String getBaseUrl() {
        String baseUrl = "https://" + SERVER_HOST + ":" + SERVER_PORT;
        if (System.getProperty("test.version") != null && System.getProperty("test.version").equals("1")) {
            return baseUrl + "/api/v1/";
        }
        return baseUrl + "/api/v2/";
    }

    private static Header getAuthHeader() {
        RestAssured.useRelaxedHTTPSValidation();
        if (System.getProperty("test.version") != null && System.getProperty("test.version").equals("1")) {
            return AbstractHttpIntegrationTest.getBasicAuthHeader();
        }
        return AbstractHttpIntegrationTest.getJWTAuthHeader();
    }

    private static Header getJWTAuthHeader() {
        Response response = (Response)RestAssured.given().contentType("application/json").body("{\"username\":\"" + USER + "\",\"password\":\"" + PASSWORD + "\"}").when().post("https://" + AbstractHttpIntegrationTest.getGatewayHost() + ":" + AbstractHttpIntegrationTest.getGatewayPort() + "/api/v1/gateway/auth/login", new Object[0]);
        Assert.assertEquals((long)response.getStatusCode(), (long)204L);
        return new Header("Authorization", "Bearer " + response.getCookie("apimlAuthenticationToken"));
    }

    private static String getGatewayHost() {
        if (GATEWAY_HOST != null) {
            return GATEWAY_HOST;
        }
        return SERVER_HOST;
    }

    private static String getGatewayPort() {
        if (GATEWAY_PORT != null) {
            return GATEWAY_PORT;
        }
        return SERVER_PORT;
    }

    private static Header getBasicAuthHeader() {
        String credentials = System.getProperty("server.username") + ":" + System.getProperty("server.password");
        byte[] encodedAuth = Base64.encodeBase64((byte[])credentials.getBytes(StandardCharsets.ISO_8859_1));
        return new Header("Authorization", "Basic " + new String(encodedAuth));
    }

    @BeforeClass
    public static void setupRestAssured() {
        RestAssured.baseURI = BASE_URL;
    }

    protected void verifyExceptionReturn(ZoweApiRestException expected, Response response) {
        this.verifyExceptionReturn(expected.getApiError(), response);
    }

    protected void verifyExceptionReturn(ApiError expectedError, Response response) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)response.then()).statusCode(expectedError.getStatus().value())).contentType(ContentType.JSON)).body("status", CoreMatchers.equalTo((Object)expectedError.getStatus().name()), new Object[0])).body("message", CoreMatchers.equalTo((Object)expectedError.getMessage()), new Object[0]);
    }
}

