/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.api.common.test.services.zosmf;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.zowe.api.common.connectors.zosmf.ZosmfConnectorJWTAuth;
import org.zowe.api.common.test.ZoweApiTest;
import org.zowe.api.common.utils.JsonUtils;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.api.common.zosmf.services.AbstractZosmfRequestRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={RequestBuilder.class, JsonUtils.class, ContentType.class, AbstractZosmfRequestRunner.class})
public abstract class AbstractZosmfRequestRunnerTest
extends ZoweApiTest {
    protected static final String BASE_URL = "https://dummy.com/zosmf/";
    @Mock
    protected ZosmfConnectorJWTAuth zosmfConnector;
    @Mock
    protected HttpResponse response;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.zosmfConnector.getFullUrl(ArgumentMatchers.anyString())).thenAnswer((Answer)new Answer<URI>(){

            public URI answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return new URI(AbstractZosmfRequestRunnerTest.BASE_URL + (String)args[0]);
            }
        });
        Mockito.when((Object)this.zosmfConnector.getFullUrl(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer((Answer)new Answer<URI>(){

            public URI answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return new URI(AbstractZosmfRequestRunnerTest.BASE_URL + (String)args[0] + "?" + (String)args[1]);
            }
        });
    }

    protected void verifyInteractions(RequestBuilder requestBuilder) throws IOException, URISyntaxException {
        this.verifyInteractions(requestBuilder, false);
    }

    protected void verifyInteractions(RequestBuilder requestBuilder, boolean path) throws IOException, URISyntaxException {
        requestBuilder.setHeader(this.zosmfConnector.getAuthHeader());
        ((ZosmfConnectorJWTAuth)Mockito.verify((Object)this.zosmfConnector, (VerificationMode)Mockito.times((int)1))).executeRequest(requestBuilder);
        if (path) {
            ((ZosmfConnectorJWTAuth)Mockito.verify((Object)this.zosmfConnector, (VerificationMode)Mockito.times((int)1))).getFullUrl(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        } else {
            ((ZosmfConnectorJWTAuth)Mockito.verify((Object)this.zosmfConnector, (VerificationMode)Mockito.times((int)1))).getFullUrl(ArgumentMatchers.anyString());
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.zosmfConnector});
    }

    protected RequestBuilder mockGetBuilder(String relativeUri) throws URISyntaxException {
        RequestBuilder builder = (RequestBuilder)Mockito.mock(RequestBuilder.class);
        PowerMockito.mockStatic(RequestBuilder.class, (Class[])new Class[0]);
        URI uri = new URI(BASE_URL + relativeUri);
        Mockito.when((Object)builder.getUri()).thenReturn((Object)uri);
        Mockito.when((Object)RequestBuilder.get((URI)uri)).thenReturn((Object)builder);
        return builder;
    }

    protected RequestBuilder mockDeleteBuilder(String relativeUri) throws URISyntaxException {
        RequestBuilder builder = (RequestBuilder)Mockito.mock(RequestBuilder.class);
        PowerMockito.mockStatic(RequestBuilder.class, (Class[])new Class[0]);
        URI uri = new URI(BASE_URL + relativeUri);
        Mockito.when((Object)builder.getUri()).thenReturn((Object)uri);
        Mockito.when((Object)RequestBuilder.delete((URI)uri)).thenReturn((Object)builder);
        return builder;
    }

    protected RequestBuilder mockPutBuilder(String relativeUri, String string) throws Exception {
        StringEntity stringEntity = (StringEntity)Mockito.mock(StringEntity.class);
        PowerMockito.whenNew(StringEntity.class).withArguments((Object)string, new Object[0]).thenReturn((Object)stringEntity);
        return this.mockPutBuilder(relativeUri, stringEntity);
    }

    protected RequestBuilder mockPutBuilder(String relativeUri, JsonObject json) throws Exception {
        StringEntity stringEntity = (StringEntity)Mockito.mock(StringEntity.class);
        PowerMockito.whenNew(StringEntity.class).withArguments((Object)json.toString(), new Object[]{ContentType.APPLICATION_JSON}).thenReturn((Object)stringEntity);
        return this.mockPutBuilder(relativeUri, stringEntity);
    }

    private RequestBuilder mockPutBuilder(String relativeUri, StringEntity stringEntity) throws Exception {
        RequestBuilder builder = (RequestBuilder)Mockito.mock(RequestBuilder.class);
        PowerMockito.mockStatic(RequestBuilder.class, (Class[])new Class[0]);
        URI uri = new URI(BASE_URL + relativeUri);
        Mockito.when((Object)builder.getUri()).thenReturn((Object)uri);
        Mockito.when((Object)RequestBuilder.put((URI)uri)).thenReturn((Object)builder);
        Mockito.when((Object)builder.setHeader("Content-Type", "application/json")).thenReturn((Object)builder);
        Mockito.when((Object)builder.setEntity((HttpEntity)stringEntity)).thenReturn((Object)builder);
        return builder;
    }

    protected RequestBuilder mockPostBuilder(String relativeUri, String string) throws Exception {
        StringEntity stringEntity = (StringEntity)Mockito.mock(StringEntity.class);
        PowerMockito.whenNew(StringEntity.class).withArguments((Object)string, new Object[0]).thenReturn((Object)stringEntity);
        return this.mockPostBuilder(relativeUri, stringEntity);
    }

    protected RequestBuilder mockPostBuilder(String relativeUri, JsonObject json) throws Exception {
        StringEntity stringEntity = (StringEntity)Mockito.mock(StringEntity.class);
        PowerMockito.whenNew(StringEntity.class).withArguments((Object)json.toString(), new Object[]{ContentType.APPLICATION_JSON}).thenReturn((Object)stringEntity);
        return this.mockPostBuilder(relativeUri, stringEntity);
    }

    protected RequestBuilder mockPostBuilder(String relativeUri, StringEntity stringEntity) throws Exception {
        RequestBuilder builder = (RequestBuilder)Mockito.mock(RequestBuilder.class);
        PowerMockito.mockStatic(RequestBuilder.class, (Class[])new Class[0]);
        URI uri = new URI(BASE_URL + relativeUri);
        Mockito.when((Object)RequestBuilder.post((URI)uri)).thenReturn((Object)builder);
        Mockito.when((Object)builder.setHeader("Content-Type", "application/json")).thenReturn((Object)builder);
        Mockito.when((Object)builder.setEntity((HttpEntity)stringEntity)).thenReturn((Object)builder);
        Mockito.when((Object)builder.getUri()).thenReturn((Object)uri);
        return builder;
    }

    protected ResponseCache mockJsonResponse(int statusCode, String jsonString) throws Exception {
        ResponseCache responseCache = this.mockResponseAndContentType(statusCode, jsonString, ContentType.APPLICATION_JSON);
        JsonElement json = (JsonElement)new Gson().fromJson(jsonString, JsonElement.class);
        Mockito.when((Object)responseCache.getEntityAsJson()).thenReturn((Object)json);
        if (json.isJsonArray()) {
            Mockito.when((Object)responseCache.getEntityAsJsonArray()).thenReturn((Object)json.getAsJsonArray());
        } else if (json.isJsonObject()) {
            Mockito.when((Object)responseCache.getEntityAsJsonObject()).thenReturn((Object)json.getAsJsonObject());
        }
        return responseCache;
    }

    protected ResponseCache mockTextResponse(int statusCode, String text) throws Exception {
        return this.mockResponseAndContentType(statusCode, text, ContentType.TEXT_PLAIN);
    }

    private ResponseCache mockResponseAndContentType(int statusCode, String entityString, ContentType contentType) throws Exception {
        ResponseCache responseCache = this.mockResponseCache(statusCode);
        Mockito.when((Object)responseCache.getEntity()).thenReturn((Object)entityString);
        ContentType mockContentType = (ContentType)Mockito.mock(ContentType.class);
        Mockito.when((Object)responseCache.getContentType()).thenReturn((Object)contentType);
        Mockito.when((Object)mockContentType.getMimeType()).thenReturn((Object)contentType.getMimeType());
        return responseCache;
    }

    protected ResponseCache mockResponseCache(int statusCode) throws Exception {
        ResponseCache responseCache = (ResponseCache)Mockito.mock(ResponseCache.class);
        PowerMockito.whenNew(ResponseCache.class).withArguments((Object)this.response, new Object[0]).thenReturn((Object)responseCache);
        Mockito.when((Object)responseCache.getStatus()).thenReturn((Object)statusCode);
        return responseCache;
    }

    protected String loadTestFile(String relativePath) throws IOException {
        return this.loadFile("src/test/resources/zosmfResponses/" + relativePath);
    }
}

