/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.api.common.test;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.zowe.api.common.errors.ApiError;
import org.zowe.api.common.exceptions.ZoweApiRestException;

public abstract class AbstractHttpIntegrationTest {
    private static final String SERVER_HOST = System.getProperty("server.host");
    private static final String SERVER_PORT = System.getProperty("server.port");
    protected static final String BASE_URL = "https://" + SERVER_HOST + ":" + SERVER_PORT + "/api/v1/";
    protected static final String USER = System.getProperty("server.username");
    private static final String PASSWORD = System.getProperty("server.password");
    protected final String AUTH_TOKEN;

    public AbstractHttpIntegrationTest() {
        Response response = (Response)RestAssured.given().contentType("application/json").body("{\"username\":\"" + USER + "\",\"password\":\"" + PASSWORD + "\"}").when().post(BASE_URL + "gateway/auth/login", new Object[0]);
        Assert.assertEquals((long)response.getStatusCode(), (long)204L);
        this.AUTH_TOKEN = response.getCookie("apimlAuthenticationToken");
        System.out.println(this.AUTH_TOKEN);
    }

    protected void verifyExceptionReturn(ZoweApiRestException expected, Response response) {
        this.verifyExceptionReturn(expected.getApiError(), response);
    }

    protected void verifyExceptionReturn(ApiError expectedError, Response response) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)response.then()).statusCode(expectedError.getStatus().value())).contentType(ContentType.JSON)).body("status", CoreMatchers.equalTo((Object)expectedError.getStatus().name()), new Object[0])).body("message", CoreMatchers.equalTo((Object)expectedError.getMessage()), new Object[0]);
    }
}

