/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class SimpleHttpResponse {
    private final int code;
    private final byte[] byteBody;
    private final String stringBody;
    private final Map<String, List<Header>> headers;

    public SimpleHttpResponse(int code, byte[] byteBody) {
        this(code, byteBody, null, Map.of());
    }

    public SimpleHttpResponse(int code, String stringBody) {
        this(code, null, stringBody, Map.of());
    }

    public SimpleHttpResponse(int code, String stringBody, Map<String, List<Header>> headers) {
        this(code, null, stringBody, headers);
    }

    public SimpleHttpResponse(int code) {
        this(code, null, null, Map.of());
    }

    public SimpleHttpResponse(int code, Map<String, List<Header>> headers) {
        this(code, null, null, headers);
    }

    public static SimpleHttpResponse fromResponseWithBytesBodyOnSuccess(ClassicHttpResponse response) throws IOException, ParseException {
        if (response.getEntity() != null) {
            if (SimpleHttpResponse.isSuccessInternal(response.getCode())) {
                return new SimpleHttpResponse(response.getCode(), response.getEntity().getContent().readAllBytes());
            }
            return new SimpleHttpResponse(response.getCode(), EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        return new SimpleHttpResponse(response.getCode());
    }

    public boolean isSuccess() {
        return SimpleHttpResponse.isSuccessInternal(this.code);
    }

    private static boolean isSuccessInternal(int code) {
        return code >= 200 && code < 300;
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public byte[] getByteBody() {
        return this.byteBody;
    }

    @Generated
    public String getStringBody() {
        return this.stringBody;
    }

    @Generated
    public Map<String, List<Header>> getHeaders() {
        return this.headers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleHttpResponse)) {
            return false;
        }
        SimpleHttpResponse other = (SimpleHttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        if (!Arrays.equals(this.getByteBody(), other.getByteBody())) {
            return false;
        }
        String this$stringBody = this.getStringBody();
        String other$stringBody = other.getStringBody();
        if (this$stringBody == null ? other$stringBody != null : !this$stringBody.equals(other$stringBody)) {
            return false;
        }
        Map<String, List<Header>> this$headers = this.getHeaders();
        Map<String, List<Header>> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimpleHttpResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        result = result * 59 + Arrays.hashCode(this.getByteBody());
        String $stringBody = this.getStringBody();
        result = result * 59 + ($stringBody == null ? 43 : $stringBody.hashCode());
        Map<String, List<Header>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SimpleHttpResponse(code=" + this.getCode() + ", byteBody=" + Arrays.toString(this.getByteBody()) + ", stringBody=" + this.getStringBody() + ", headers=" + this.getHeaders() + ")";
    }

    @Generated
    public SimpleHttpResponse(int code, byte[] byteBody, String stringBody, Map<String, List<Header>> headers) {
        this.code = code;
        this.byteBody = byteBody;
        this.stringBody = stringBody;
        this.headers = headers;
    }
}

