/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.service.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.HttpCookie;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.zaasclient.config.ConfigProperties;
import org.zowe.apiml.zaasclient.exception.ZaasClientErrorCodes;
import org.zowe.apiml.zaasclient.exception.ZaasClientException;
import org.zowe.apiml.zaasclient.service.ZaasToken;
import org.zowe.apiml.zaasclient.service.internal.TokenService;
import org.zowe.apiml.zaasclient.util.SimpleHttpResponse;

class ZaasJwtService
implements TokenService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZaasJwtService.class);
    private static final String BEARER_AUTHENTICATION_PREFIX = "Bearer";
    private final String loginEndpoint;
    private final String queryEndpoint;
    private final String logoutEndpoint;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper objectMapper = new ObjectMapper();
    ConfigProperties zaasConfigProperties;

    public ZaasJwtService(CloseableHttpClient client, String baseUrl, ConfigProperties configProperties) {
        this.httpClient = client;
        this.loginEndpoint = baseUrl + "/login";
        this.queryEndpoint = baseUrl + "/query";
        this.logoutEndpoint = baseUrl + "/logout";
        this.zaasConfigProperties = configProperties;
    }

    @Override
    public String login(String userId, char[] password, char[] newPassword) throws ZaasClientException {
        return (String)this.doRequest(() -> this.loginWithCredentials(userId, password, newPassword), (HttpClientResponseHandler<SimpleHttpResponse>)((HttpClientResponseHandler)this::processJwtTokenResponse), this::extractToken);
    }

    @Override
    public String login(String userId, char[] password) throws ZaasClientException {
        return (String)this.doRequest(() -> this.loginWithCredentials(userId, password, null), (HttpClientResponseHandler<SimpleHttpResponse>)((HttpClientResponseHandler)this::processJwtTokenResponse), this::extractToken);
    }

    private ClassicHttpRequest loginWithCredentials(String userId, char[] password, char[] newPassword) throws IOException {
        HttpPost httpPost = new HttpPost(this.loginEndpoint);
        String json = this.objectMapper.writeValueAsString((Object)new Credentials(userId, password, newPassword));
        StringEntity entity = new StringEntity(json);
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeader("Content-Type", (Object)"application/json");
        return httpPost;
    }

    private SimpleHttpResponse processJwtTokenResponse(ClassicHttpResponse response) throws ParseException, IOException {
        Map<String, List<Header>> headers = Arrays.stream(response.getHeaders("Set-Cookie")).collect(Collectors.groupingBy(__ -> "Set-Cookie"));
        if (response.getEntity() != null) {
            return new SimpleHttpResponse(response.getCode(), EntityUtils.toString((HttpEntity)response.getEntity()), headers);
        }
        return new SimpleHttpResponse(response.getCode(), headers);
    }

    @Override
    public String login(String authorizationHeader) throws ZaasClientException {
        return (String)this.doRequest(() -> this.loginWithHeader(authorizationHeader), (HttpClientResponseHandler<SimpleHttpResponse>)((HttpClientResponseHandler)this::processJwtTokenResponse), this::extractToken);
    }

    private ClassicHttpRequest loginWithHeader(String authorizationHeader) {
        HttpPost httpPost = new HttpPost(this.loginEndpoint);
        httpPost.setHeader("Authorization", (Object)authorizationHeader);
        return httpPost;
    }

    @Override
    public ZaasToken query(String jwtToken) throws ZaasClientException {
        if (jwtToken == null || jwtToken.isEmpty()) {
            throw new ZaasClientException(ZaasClientErrorCodes.TOKEN_NOT_PROVIDED, "No token provided");
        }
        return (ZaasToken)this.doRequest(() -> this.queryWithJwtToken(jwtToken), (HttpClientResponseHandler<SimpleHttpResponse>)((HttpClientResponseHandler)SimpleHttpResponse::fromResponseWithBytesBodyOnSuccess), this::extractZaasToken);
    }

    @Override
    public ZaasToken query(@NonNull HttpServletRequest request) throws ZaasClientException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Optional<String> jwtToken = this.getJwtTokenFromRequest(request);
        return this.query((String)jwtToken.orElse(null));
    }

    @Override
    public void logout(String jwtToken) throws ZaasClientException {
        this.doLogoutRequest(() -> this.logoutJwtToken(jwtToken));
    }

    private Optional<String> getJwtTokenFromRequest(@NonNull HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Optional<String> fromCookie = this.getJwtTokenFromCookie(request);
        return fromCookie.isPresent() ? fromCookie : this.extractJwtTokenFromAuthorizationHeader(request.getHeader("Authorization"));
    }

    private Optional<String> getJwtTokenFromCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return Optional.empty();
        }
        return Arrays.stream(cookies).filter(cookie -> cookie.getName().equals(this.zaasConfigProperties.getTokenPrefix())).filter(cookie -> !cookie.getValue().isEmpty()).findFirst().map(Cookie::getValue);
    }

    private Optional<String> extractJwtTokenFromAuthorizationHeader(String header) {
        if (header != null && header.startsWith(BEARER_AUTHENTICATION_PREFIX)) {
            if ((header = header.replaceFirst(BEARER_AUTHENTICATION_PREFIX, "").trim()).isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(header);
        }
        return Optional.empty();
    }

    private ClassicHttpRequest queryWithJwtToken(String jwtToken) {
        HttpGet httpGet = new HttpGet(this.queryEndpoint);
        httpGet.addHeader("Cookie", (Object)(this.zaasConfigProperties.getTokenPrefix() + "=" + jwtToken));
        return httpGet;
    }

    private ClassicHttpRequest logoutJwtToken(String jwtToken) {
        HttpPost httpPost = new HttpPost(this.logoutEndpoint);
        if (jwtToken.startsWith(BEARER_AUTHENTICATION_PREFIX)) {
            httpPost.addHeader("Authorization", (Object)jwtToken);
        } else {
            httpPost.addHeader("Cookie", (Object)(this.zaasConfigProperties.getTokenPrefix() + "=" + jwtToken));
        }
        return httpPost;
    }

    private void handleErrorMessage(JsonNode message, Predicate<ZaasClientErrorCodes> condition) throws ZaasClientException {
        String messageNumber;
        ZaasClientErrorCodes zaasClientErrorCode;
        JsonNode messageNumberNode = message.get("messageNumber");
        if (messageNumberNode != null && messageNumberNode.getNodeType() == JsonNodeType.STRING && condition.test(zaasClientErrorCode = ZaasClientErrorCodes.byErrorNumber(messageNumber = messageNumberNode.asText()))) {
            throw new ZaasClientException(zaasClientErrorCode, zaasClientErrorCode.getMessage());
        }
    }

    private void handleErrorMessage(String errorMessage, Predicate<ZaasClientErrorCodes> condition) throws ZaasClientException, IOException {
        if (errorMessage == null) {
            return;
        }
        JsonNode jsonNode = this.objectMapper.readTree(errorMessage);
        JsonNode messages = jsonNode.get("messages");
        if (messages != null && messages.getNodeType() == JsonNodeType.ARRAY) {
            ArrayNode messagesArray = (ArrayNode)messages;
            for (JsonNode message : messagesArray) {
                this.handleErrorMessage(message, condition);
            }
        }
    }

    private ZaasToken extractZaasToken(SimpleHttpResponse response) throws IOException, ZaasClientException {
        int statusCode = response.getCode();
        if (statusCode == 200) {
            ZaasToken token = (ZaasToken)this.objectMapper.readValue(response.getByteBody(), ZaasToken.class);
            if (token == null) {
                throw new ZaasClientException(ZaasClientErrorCodes.TOKEN_NOT_PROVIDED, "Queried token is null");
            }
            if (token.isExpired()) {
                throw new ZaasClientException(ZaasClientErrorCodes.EXPIRED_JWT_EXCEPTION, "Queried token is expired");
            }
            return token;
        }
        if (statusCode == 401) {
            this.handleErrorMessage(response.getStringBody(), ZaasClientErrorCodes.EXPIRED_PASSWORD::equals);
            throw new ZaasClientException(ZaasClientErrorCodes.INVALID_JWT_TOKEN, "Queried token is invalid or expired");
        }
        throw new ZaasClientException(ZaasClientErrorCodes.GENERIC_EXCEPTION, response.getStringBody());
    }

    private String extractToken(SimpleHttpResponse response) throws ZaasClientException, IOException {
        String token = "";
        int httpResponseCode = response.getCode();
        if (httpResponseCode == 204) {
            List cookies = response.getHeaders().get("Set-Cookie").stream().map(header -> HttpCookie.parse(header.getValue())).flatMap(Collection::stream).toList();
            Optional<String> apimlAuthCookie = cookies.stream().filter(cookie -> cookie.getName().equals(this.zaasConfigProperties.getTokenPrefix())).map(HttpCookie::getValue).findFirst();
            if (apimlAuthCookie.isPresent()) {
                token = apimlAuthCookie.get();
            }
            return token;
        }
        if (httpResponseCode == 401) {
            this.handleErrorMessage(response.getStringBody(), ZaasClientErrorCodes.EXPIRED_PASSWORD::equals);
            throw new ZaasClientException(ZaasClientErrorCodes.INVALID_AUTHENTICATION, response.getStringBody());
        }
        if (httpResponseCode == 400) {
            throw new ZaasClientException(ZaasClientErrorCodes.EMPTY_NULL_USERNAME_PASSWORD, response.getStringBody());
        }
        throw new ZaasClientException(ZaasClientErrorCodes.GENERIC_EXCEPTION, response.getStringBody());
    }

    private void doLogoutRequest(OperationGenerator requestGenerator) throws ZaasClientException {
        SimpleHttpResponse response = this.getSimpleResponse(requestGenerator, (HttpClientResponseHandler<SimpleHttpResponse>)((HttpClientResponseHandler)SimpleHttpResponse::fromResponseWithBytesBodyOnSuccess));
        if (response.getCode() == 401) {
            throw new ZaasClientException(ZaasClientErrorCodes.EXPIRED_JWT_EXCEPTION, response.getStringBody());
        }
        if (!response.isSuccess()) {
            throw new ZaasClientException(ZaasClientErrorCodes.INVALID_JWT_TOKEN, response.getStringBody());
        }
    }

    private Object doRequest(OperationGenerator requestGenerator, HttpClientResponseHandler<SimpleHttpResponse> responseHandler, TokenExtractor token) throws ZaasClientException {
        try {
            return token.extract(this.getSimpleResponse(requestGenerator, responseHandler));
        }
        catch (ZaasClientException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, (Throwable)e);
        }
        catch (Exception e) {
            throw new ZaasClientException(ZaasClientErrorCodes.GENERIC_EXCEPTION, (Throwable)e);
        }
    }

    private SimpleHttpResponse getSimpleResponse(OperationGenerator operationGenerator, HttpClientResponseHandler<SimpleHttpResponse> responseHandler) throws ZaasClientException {
        try {
            return (SimpleHttpResponse)this.httpClient.execute(operationGenerator.request(), responseHandler);
        }
        catch (IOException e) {
            throw new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, (Throwable)e);
        }
    }

    static interface OperationGenerator {
        public ClassicHttpRequest request() throws IOException;
    }

    static interface TokenExtractor {
        public Object extract(SimpleHttpResponse var1) throws IOException, ZaasClientException;
    }

    static class Credentials {
        String username;
        char[] password;
        char[] newPassword;

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public char[] getPassword() {
            return this.password;
        }

        @Generated
        public char[] getNewPassword() {
            return this.newPassword;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setPassword(char[] password) {
            this.password = password;
        }

        @Generated
        public void setNewPassword(char[] newPassword) {
            this.newPassword = newPassword;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Credentials)) {
                return false;
            }
            Credentials other = (Credentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            if (!Arrays.equals(this.getPassword(), other.getPassword())) {
                return false;
            }
            return Arrays.equals(this.getNewPassword(), other.getNewPassword());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Credentials;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            result = result * 59 + Arrays.hashCode(this.getPassword());
            result = result * 59 + Arrays.hashCode(this.getNewPassword());
            return result;
        }

        @Generated
        public String toString() {
            return "ZaasJwtService.Credentials(username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", newPassword=" + Arrays.toString(this.getNewPassword()) + ")";
        }

        @Generated
        public Credentials(String username, char[] password, char[] newPassword) {
            this.username = username;
            this.password = password;
            this.newPassword = newPassword;
        }
    }
}

