/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.service.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.zowe.apiml.zaasclient.config.ConfigProperties;
import org.zowe.apiml.zaasclient.exception.ZaasClientErrorCodes;
import org.zowe.apiml.zaasclient.exception.ZaasClientException;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationException;
import org.zowe.apiml.zaasclient.passticket.ZaasClientTicketRequest;
import org.zowe.apiml.zaasclient.passticket.ZaasPassTicketResponse;
import org.zowe.apiml.zaasclient.service.internal.CloseableClientProvider;
import org.zowe.apiml.zaasclient.service.internal.PassTicketService;

class PassTicketServiceImpl
implements PassTicketService {
    private final CloseableClientProvider httpClientProvider;
    private final String ticketUrl;
    ConfigProperties passConfigProperties;

    public PassTicketServiceImpl(CloseableClientProvider client, String baseUrl, ConfigProperties configProperties) {
        this.httpClientProvider = client;
        this.ticketUrl = baseUrl + "/ticket";
        this.passConfigProperties = configProperties;
    }

    @Override
    public String passTicket(String jwtToken, String applicationId) throws ZaasClientException, ZaasConfigurationException {
        try {
            CloseableHttpClient closeableHttpsClient = this.httpClientProvider.getHttpClient();
            HttpPost httpPost = this.getHttpPost(jwtToken, applicationId);
            CloseableHttpResponse response = closeableHttpsClient.execute((ClassicHttpRequest)httpPost);
            return this.extractPassTicket((ClassicHttpResponse)response);
        }
        catch (ZaasConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, (Throwable)e);
        }
    }

    private HttpPost getHttpPost(String jwtToken, String applicationId) throws JsonProcessingException {
        ZaasClientTicketRequest zaasClientTicketRequest = new ZaasClientTicketRequest();
        ObjectMapper mapper = new ObjectMapper();
        zaasClientTicketRequest.setApplicationName(applicationId);
        HttpPost httpPost = new HttpPost(this.ticketUrl);
        httpPost.setEntity((HttpEntity)new StringEntity(mapper.writeValueAsString((Object)zaasClientTicketRequest)));
        httpPost.setHeader("Content-Type", (Object)"application/json");
        httpPost.setHeader("Cookie", (Object)(this.passConfigProperties.getTokenPrefix() + "=" + jwtToken));
        return httpPost;
    }

    private String extractPassTicket(ClassicHttpResponse response) throws IOException, ZaasClientException, ParseException {
        int statusCode = response.getCode();
        if (statusCode == 200) {
            ObjectMapper mapper = new ObjectMapper();
            ZaasPassTicketResponse zaasPassTicketResponse = (ZaasPassTicketResponse)mapper.readValue(response.getEntity().getContent(), ZaasPassTicketResponse.class);
            return zaasPassTicketResponse.getTicket();
        }
        String obtainedMessage = EntityUtils.toString((HttpEntity)response.getEntity());
        if (statusCode == 401) {
            throw new ZaasClientException(ZaasClientErrorCodes.INVALID_AUTHENTICATION, obtainedMessage);
        }
        if (statusCode == 400) {
            throw new ZaasClientException(ZaasClientErrorCodes.BAD_REQUEST, obtainedMessage);
        }
        if (statusCode == 500) {
            throw new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, obtainedMessage);
        }
        throw new ZaasClientException(ZaasClientErrorCodes.GENERIC_EXCEPTION, obtainedMessage);
    }
}

