/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.service.internal;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.zowe.apiml.zaasclient.config.ConfigProperties;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationErrorCodes;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationException;
import org.zowe.apiml.zaasclient.service.internal.CloseableClientProvider;

class ZaasHttpsClientProvider
implements CloseableClientProvider {
    private static final int REQUEST_TIMEOUT = 30000;
    private final RequestConfig requestConfig;
    private static final Pattern KEYRING_PATTERN = Pattern.compile("^(safkeyring[^:]*):/{2,4}([^/]+)/([^/]+)$");
    private ConfigProperties configProperties;
    private TrustManagerFactory tmf;
    private KeyManagerFactory kmf;
    private final HostnameVerifier hostnameVerifier;
    private final CookieStore cookieStore = new BasicCookieStore();
    private CloseableHttpClient httpsClient;

    public ZaasHttpsClientProvider(ConfigProperties configProperties) throws ZaasConfigurationException {
        if (configProperties.getTrustStorePath() == null) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.TRUST_STORE_NOT_PROVIDED);
        }
        this.configProperties = configProperties;
        this.requestConfig = this.buildCustomRequestConfig();
        this.initializeTrustManagerFactory(configProperties.getTrustStorePath(), configProperties.getTrustStoreType(), configProperties.getTrustStorePassword());
        this.hostnameVerifier = configProperties.isNonStrictVerifySslCertificatesOfServices() ? new NoopHostnameVerifier() : SSLConnectionSocketFactory.getDefaultHostnameVerifier();
    }

    static boolean isKeyring(String input) {
        if (input == null) {
            return false;
        }
        Matcher matcher = KEYRING_PATTERN.matcher(input);
        return matcher.matches();
    }

    static String formatKeyringUrl(String input) {
        if (input == null) {
            return null;
        }
        Matcher matcher = KEYRING_PATTERN.matcher(input);
        if (matcher.matches()) {
            return matcher.group(1) + "://" + matcher.group(2) + "/" + matcher.group(3);
        }
        return input;
    }

    public void clearCookieStore() {
        this.cookieStore.clear();
    }

    @Override
    public synchronized CloseableHttpClient getHttpClient() throws ZaasConfigurationException {
        if (this.httpsClient == null) {
            if (this.kmf == null) {
                this.initializeKeyStoreManagerFactory();
            }
            this.httpsClient = this.sharedHttpClientConfiguration(this.getSSLContext()).build();
        }
        return this.httpsClient;
    }

    private void initializeTrustManagerFactory(String trustStorePath, String trustStoreType, char[] trustStorePassword) throws ZaasConfigurationException {
        try {
            this.tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore trustStore = this.getKeystore(trustStorePath, trustStoreType, trustStorePassword);
            this.tmf.init(trustStore);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.WRONG_CRYPTO_CONFIGURATION, (Throwable)e);
        }
        catch (IOException e) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.IO_CONFIGURATION_ISSUE, (Throwable)e);
        }
    }

    private void initializeKeyStoreManagerFactory() throws ZaasConfigurationException {
        try {
            KeyStore keyStore = this.configProperties.getKeyStorePath() != null ? this.getKeystore(this.configProperties.getKeyStorePath(), this.configProperties.getKeyStoreType(), this.configProperties.getKeyStorePassword()) : this.getEmptyKeystore();
            this.kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            this.kmf.init(keyStore, this.configProperties.getKeyStorePassword());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.WRONG_CRYPTO_CONFIGURATION, (Throwable)e);
        }
        catch (IOException e) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.IO_CONFIGURATION_ISSUE, (Throwable)e);
        }
    }

    private KeyStore getKeystore(String uri, String keyStoreType, char[] storePassword) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        try (InputStream correctInStream = this.getCorrectInputStream(uri);){
            keyStore.load(correctInStream, storePassword);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    private KeyStore getEmptyKeystore() throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        KeyStore emptyKeystore = KeyStore.getInstance(KeyStore.getDefaultType());
        emptyKeystore.load(null, null);
        return emptyKeystore;
    }

    private InputStream getCorrectInputStream(String uri) throws IOException {
        if (ZaasHttpsClientProvider.isKeyring(uri)) {
            URL url = new URL(ZaasHttpsClientProvider.formatKeyringUrl(uri));
            return url.openStream();
        }
        return new FileInputStream(uri);
    }

    private SSLContext getSSLContext() throws ZaasConfigurationException {
        try {
            SSLContext sslContext = SSLContext.getInstance(this.configProperties.getProtocol());
            sslContext.init(this.kmf != null ? this.kmf.getKeyManagers() : null, this.tmf.getTrustManagers(), new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.WRONG_CRYPTO_CONFIGURATION, (Throwable)e);
        }
    }

    private HttpClientBuilder sharedHttpClientConfiguration(SSLContext sslContext) {
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, this.hostnameVerifier);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultRequestConfig(this.requestConfig).setMaxConnTotal(9).setMaxConnPerRoute(3).setDefaultCookieStore(this.cookieStore);
    }

    private RequestConfig buildCustomRequestConfig() {
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectionRequestTimeout(30000);
        builder.setSocketTimeout(30000);
        builder.setConnectTimeout(30000);
        return builder.build();
    }

    @Generated
    public ZaasHttpsClientProvider(RequestConfig requestConfig, ConfigProperties configProperties, TrustManagerFactory tmf, KeyManagerFactory kmf, HostnameVerifier hostnameVerifier, CloseableHttpClient httpsClient) {
        this.requestConfig = requestConfig;
        this.configProperties = configProperties;
        this.tmf = tmf;
        this.kmf = kmf;
        this.hostnameVerifier = hostnameVerifier;
        this.httpsClient = httpsClient;
    }
}

