/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.config;

import java.util.Arrays;
import lombok.Generated;

public class ConfigProperties {
    private String apimlHost;
    private String apimlPort;
    private String apimlBaseUrl;
    private String keyStoreType;
    private String keyStorePath;
    private char[] keyStorePassword;
    private String trustStoreType;
    private String trustStorePath;
    private char[] trustStorePassword;
    private boolean httpOnly;
    private boolean nonStrictVerifySslCertificatesOfServices;
    private String protocol;
    private static final String OLD_PATH_FORMAT = "/api/v1/gateway";
    private static final String NEW_PATH_FORMAT = "/gateway/api/v1";
    private String tokenPrefix;

    public ConfigProperties() {
        this.protocol = "TLS";
        this.tokenPrefix = "apimlAuthenticationToken";
    }

    public ConfigProperties withoutKeyStore() {
        return ConfigProperties.builder().apimlHost(this.apimlHost).apimlPort(this.apimlPort).apimlBaseUrl(this.apimlBaseUrl).trustStoreType(this.trustStoreType).trustStorePath(this.trustStorePath).trustStorePassword(this.trustStorePassword).httpOnly(this.httpOnly).nonStrictVerifySslCertificatesOfServices(this.nonStrictVerifySslCertificatesOfServices).protocol(this.protocol).tokenPrefix(this.tokenPrefix).build();
    }

    public void setApimlBaseUrl(String baseUrl) {
        if (baseUrl == null) {
            baseUrl = "/gateway/api/v1/auth";
        }
        if (!baseUrl.startsWith("/")) {
            baseUrl = "/" + baseUrl;
        }
        if (baseUrl.startsWith(OLD_PATH_FORMAT)) {
            baseUrl = NEW_PATH_FORMAT + baseUrl.substring(OLD_PATH_FORMAT.length());
        }
        this.apimlBaseUrl = baseUrl;
    }

    @Generated
    private static String $default$protocol() {
        return "TLS";
    }

    @Generated
    private static String $default$tokenPrefix() {
        return "apimlAuthenticationToken";
    }

    @Generated
    ConfigProperties(String apimlHost, String apimlPort, String apimlBaseUrl, String keyStoreType, String keyStorePath, char[] keyStorePassword, String trustStoreType, String trustStorePath, char[] trustStorePassword, boolean httpOnly, boolean nonStrictVerifySslCertificatesOfServices, String protocol, String tokenPrefix) {
        this.apimlHost = apimlHost;
        this.apimlPort = apimlPort;
        this.apimlBaseUrl = apimlBaseUrl;
        this.keyStoreType = keyStoreType;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.trustStoreType = trustStoreType;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.httpOnly = httpOnly;
        this.nonStrictVerifySslCertificatesOfServices = nonStrictVerifySslCertificatesOfServices;
        this.protocol = protocol;
        this.tokenPrefix = tokenPrefix;
    }

    @Generated
    public static ConfigPropertiesBuilder builder() {
        return new ConfigPropertiesBuilder();
    }

    @Generated
    public String getApimlHost() {
        return this.apimlHost;
    }

    @Generated
    public String getApimlPort() {
        return this.apimlPort;
    }

    @Generated
    public String getApimlBaseUrl() {
        return this.apimlBaseUrl;
    }

    @Generated
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Generated
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Generated
    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Generated
    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @Generated
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Generated
    public char[] getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Generated
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Generated
    public boolean isNonStrictVerifySslCertificatesOfServices() {
        return this.nonStrictVerifySslCertificatesOfServices;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public String getTokenPrefix() {
        return this.tokenPrefix;
    }

    @Generated
    public void setApimlHost(String apimlHost) {
        this.apimlHost = apimlHost;
    }

    @Generated
    public void setApimlPort(String apimlPort) {
        this.apimlPort = apimlPort;
    }

    @Generated
    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    @Generated
    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    @Generated
    public void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @Generated
    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    @Generated
    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    @Generated
    public void setTrustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @Generated
    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    @Generated
    public void setNonStrictVerifySslCertificatesOfServices(boolean nonStrictVerifySslCertificatesOfServices) {
        this.nonStrictVerifySslCertificatesOfServices = nonStrictVerifySslCertificatesOfServices;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setTokenPrefix(String tokenPrefix) {
        this.tokenPrefix = tokenPrefix;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigProperties)) {
            return false;
        }
        ConfigProperties other = (ConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHttpOnly() != other.isHttpOnly()) {
            return false;
        }
        if (this.isNonStrictVerifySslCertificatesOfServices() != other.isNonStrictVerifySslCertificatesOfServices()) {
            return false;
        }
        String this$apimlHost = this.getApimlHost();
        String other$apimlHost = other.getApimlHost();
        if (this$apimlHost == null ? other$apimlHost != null : !this$apimlHost.equals(other$apimlHost)) {
            return false;
        }
        String this$apimlPort = this.getApimlPort();
        String other$apimlPort = other.getApimlPort();
        if (this$apimlPort == null ? other$apimlPort != null : !this$apimlPort.equals(other$apimlPort)) {
            return false;
        }
        String this$apimlBaseUrl = this.getApimlBaseUrl();
        String other$apimlBaseUrl = other.getApimlBaseUrl();
        if (this$apimlBaseUrl == null ? other$apimlBaseUrl != null : !this$apimlBaseUrl.equals(other$apimlBaseUrl)) {
            return false;
        }
        String this$keyStoreType = this.getKeyStoreType();
        String other$keyStoreType = other.getKeyStoreType();
        if (this$keyStoreType == null ? other$keyStoreType != null : !this$keyStoreType.equals(other$keyStoreType)) {
            return false;
        }
        String this$keyStorePath = this.getKeyStorePath();
        String other$keyStorePath = other.getKeyStorePath();
        if (this$keyStorePath == null ? other$keyStorePath != null : !this$keyStorePath.equals(other$keyStorePath)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyStorePassword(), other.getKeyStorePassword())) {
            return false;
        }
        String this$trustStoreType = this.getTrustStoreType();
        String other$trustStoreType = other.getTrustStoreType();
        if (this$trustStoreType == null ? other$trustStoreType != null : !this$trustStoreType.equals(other$trustStoreType)) {
            return false;
        }
        String this$trustStorePath = this.getTrustStorePath();
        String other$trustStorePath = other.getTrustStorePath();
        if (this$trustStorePath == null ? other$trustStorePath != null : !this$trustStorePath.equals(other$trustStorePath)) {
            return false;
        }
        if (!Arrays.equals(this.getTrustStorePassword(), other.getTrustStorePassword())) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$tokenPrefix = this.getTokenPrefix();
        String other$tokenPrefix = other.getTokenPrefix();
        return !(this$tokenPrefix == null ? other$tokenPrefix != null : !this$tokenPrefix.equals(other$tokenPrefix));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfigProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHttpOnly() ? 79 : 97);
        result = result * 59 + (this.isNonStrictVerifySslCertificatesOfServices() ? 79 : 97);
        String $apimlHost = this.getApimlHost();
        result = result * 59 + ($apimlHost == null ? 43 : $apimlHost.hashCode());
        String $apimlPort = this.getApimlPort();
        result = result * 59 + ($apimlPort == null ? 43 : $apimlPort.hashCode());
        String $apimlBaseUrl = this.getApimlBaseUrl();
        result = result * 59 + ($apimlBaseUrl == null ? 43 : $apimlBaseUrl.hashCode());
        String $keyStoreType = this.getKeyStoreType();
        result = result * 59 + ($keyStoreType == null ? 43 : $keyStoreType.hashCode());
        String $keyStorePath = this.getKeyStorePath();
        result = result * 59 + ($keyStorePath == null ? 43 : $keyStorePath.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyStorePassword());
        String $trustStoreType = this.getTrustStoreType();
        result = result * 59 + ($trustStoreType == null ? 43 : $trustStoreType.hashCode());
        String $trustStorePath = this.getTrustStorePath();
        result = result * 59 + ($trustStorePath == null ? 43 : $trustStorePath.hashCode());
        result = result * 59 + Arrays.hashCode(this.getTrustStorePassword());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $tokenPrefix = this.getTokenPrefix();
        result = result * 59 + ($tokenPrefix == null ? 43 : $tokenPrefix.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConfigProperties(apimlHost=" + this.getApimlHost() + ", apimlPort=" + this.getApimlPort() + ", apimlBaseUrl=" + this.getApimlBaseUrl() + ", keyStoreType=" + this.getKeyStoreType() + ", keyStorePath=" + this.getKeyStorePath() + ", keyStorePassword=" + Arrays.toString(this.getKeyStorePassword()) + ", trustStoreType=" + this.getTrustStoreType() + ", trustStorePath=" + this.getTrustStorePath() + ", trustStorePassword=" + Arrays.toString(this.getTrustStorePassword()) + ", httpOnly=" + this.isHttpOnly() + ", nonStrictVerifySslCertificatesOfServices=" + this.isNonStrictVerifySslCertificatesOfServices() + ", protocol=" + this.getProtocol() + ", tokenPrefix=" + this.getTokenPrefix() + ")";
    }

    @Generated
    public static class ConfigPropertiesBuilder {
        @Generated
        private String apimlHost;
        @Generated
        private String apimlPort;
        @Generated
        private String apimlBaseUrl;
        @Generated
        private String keyStoreType;
        @Generated
        private String keyStorePath;
        @Generated
        private char[] keyStorePassword;
        @Generated
        private String trustStoreType;
        @Generated
        private String trustStorePath;
        @Generated
        private char[] trustStorePassword;
        @Generated
        private boolean httpOnly;
        @Generated
        private boolean nonStrictVerifySslCertificatesOfServices;
        @Generated
        private boolean protocol$set;
        @Generated
        private String protocol$value;
        @Generated
        private boolean tokenPrefix$set;
        @Generated
        private String tokenPrefix$value;

        @Generated
        ConfigPropertiesBuilder() {
        }

        @Generated
        public ConfigPropertiesBuilder apimlHost(String apimlHost) {
            this.apimlHost = apimlHost;
            return this;
        }

        @Generated
        public ConfigPropertiesBuilder apimlPort(String apimlPort) {
            this.apimlPort = apimlPort;
            return this;
        }

        @Generated
        public ConfigPropertiesBuilder apimlBaseUrl(String apimlBaseUrl) {
            this.apimlBaseUrl = apimlBaseUrl;
            return this;
        }

        @Generated
        public ConfigPropertiesBuilder keyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        @Generated
        public ConfigPropertiesBuilder keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        @Generated
        public ConfigPropertiesBuilder keyStorePassword(char[] keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        @Generated
        public ConfigPropertiesBuilder trustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this;
        }

        @Generated
        public ConfigPropertiesBuilder trustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        @Generated
        public ConfigPropertiesBuilder trustStorePassword(char[] trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        @Generated
        public ConfigPropertiesBuilder httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        @Generated
        public ConfigPropertiesBuilder nonStrictVerifySslCertificatesOfServices(boolean nonStrictVerifySslCertificatesOfServices) {
            this.nonStrictVerifySslCertificatesOfServices = nonStrictVerifySslCertificatesOfServices;
            return this;
        }

        @Generated
        public ConfigPropertiesBuilder protocol(String protocol) {
            this.protocol$value = protocol;
            this.protocol$set = true;
            return this;
        }

        @Generated
        public ConfigPropertiesBuilder tokenPrefix(String tokenPrefix) {
            this.tokenPrefix$value = tokenPrefix;
            this.tokenPrefix$set = true;
            return this;
        }

        @Generated
        public ConfigProperties build() {
            String protocol$value = this.protocol$value;
            if (!this.protocol$set) {
                protocol$value = ConfigProperties.$default$protocol();
            }
            String tokenPrefix$value = this.tokenPrefix$value;
            if (!this.tokenPrefix$set) {
                tokenPrefix$value = ConfigProperties.$default$tokenPrefix();
            }
            return new ConfigProperties(this.apimlHost, this.apimlPort, this.apimlBaseUrl, this.keyStoreType, this.keyStorePath, this.keyStorePassword, this.trustStoreType, this.trustStorePath, this.trustStorePassword, this.httpOnly, this.nonStrictVerifySslCertificatesOfServices, protocol$value, tokenPrefix$value);
        }

        @Generated
        public String toString() {
            return "ConfigProperties.ConfigPropertiesBuilder(apimlHost=" + this.apimlHost + ", apimlPort=" + this.apimlPort + ", apimlBaseUrl=" + this.apimlBaseUrl + ", keyStoreType=" + this.keyStoreType + ", keyStorePath=" + this.keyStorePath + ", keyStorePassword=" + Arrays.toString(this.keyStorePassword) + ", trustStoreType=" + this.trustStoreType + ", trustStorePath=" + this.trustStorePath + ", trustStorePassword=" + Arrays.toString(this.trustStorePassword) + ", httpOnly=" + this.httpOnly + ", nonStrictVerifySslCertificatesOfServices=" + this.nonStrictVerifySslCertificatesOfServices + ", protocol$value=" + this.protocol$value + ", tokenPrefix$value=" + this.tokenPrefix$value + ")";
        }
    }
}

