/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.service.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import lombok.NonNull;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.zaasclient.config.ConfigProperties;
import org.zowe.apiml.zaasclient.exception.ZaasClientErrorCodes;
import org.zowe.apiml.zaasclient.exception.ZaasClientException;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationException;
import org.zowe.apiml.zaasclient.service.ZaasToken;
import org.zowe.apiml.zaasclient.service.internal.CloseableClientProvider;
import org.zowe.apiml.zaasclient.service.internal.TokenService;
import org.zowe.apiml.zaasclient.service.internal.ZaasHttpsClientProvider;

class ZaasJwtService
implements TokenService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZaasJwtService.class);
    private static final String BEARER_AUTHENTICATION_PREFIX = "Bearer";
    private final String loginEndpoint;
    private final String queryEndpoint;
    private final String logoutEndpoint;
    private final CloseableClientProvider httpClientProvider;
    private final ObjectMapper objectMapper = new ObjectMapper();
    ConfigProperties zassConfigProperties;

    public ZaasJwtService(CloseableClientProvider client, String baseUrl, ConfigProperties configProperties) {
        this.httpClientProvider = client;
        this.loginEndpoint = baseUrl + "/login";
        this.queryEndpoint = baseUrl + "/query";
        this.logoutEndpoint = baseUrl + "/logout";
        this.zassConfigProperties = configProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String login(String userId, char[] password, char[] newPassword) throws ZaasClientException {
        try {
            CloseableHttpClient client = this.httpClientProvider.getHttpClient();
            HttpPost httpPost = new HttpPost(this.loginEndpoint);
            String json = this.objectMapper.writeValueAsString((Object)new Credentials(userId, password, newPassword));
            StringEntity entity = new StringEntity(json);
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Content-Type", "application/json");
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
                String string = this.extractToken(response);
                return string;
            }
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    @Override
    public String login(String userId, char[] password) throws ZaasClientException {
        return this.login(userId, password, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String login(String authorizationHeader) throws ZaasClientException {
        try {
            CloseableHttpClient client = this.httpClientProvider.getHttpClient();
            HttpPost httpPost = new HttpPost(this.loginEndpoint);
            httpPost.setHeader("Authorization", authorizationHeader);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
                String string = this.extractToken(response);
                return string;
            }
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ZaasToken query(String jwtToken) throws ZaasClientException {
        if (jwtToken == null) throw new ZaasClientException(ZaasClientErrorCodes.TOKEN_NOT_PROVIDED, "No token provided");
        if (jwtToken.isEmpty()) {
            throw new ZaasClientException(ZaasClientErrorCodes.TOKEN_NOT_PROVIDED, "No token provided");
        }
        try {
            CloseableHttpClient client = this.httpClientProvider.getHttpClient();
            HttpGet httpGet = new HttpGet(this.queryEndpoint);
            httpGet.addHeader("Cookie", this.zassConfigProperties.getTokenPrefix() + "=" + jwtToken);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);){
                ZaasToken zaasToken = this.extractZaasToken(response);
                return zaasToken;
            }
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    @Override
    public ZaasToken query(@NonNull HttpServletRequest request) throws ZaasClientException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Optional<String> jwtToken = this.getJwtTokenFromRequest(request);
        return this.query((String)jwtToken.orElse(null));
    }

    @Override
    public void logout(String jwtToken) throws ZaasClientException {
        try {
            CloseableHttpClient client = this.httpClientProvider.getHttpClient();
            this.clearZaasClientCookies();
            HttpPost httpPost = new HttpPost(this.logoutEndpoint);
            if (jwtToken.startsWith(BEARER_AUTHENTICATION_PREFIX)) {
                httpPost.addHeader("Authorization", jwtToken);
            } else {
                httpPost.addHeader("Cookie", this.zassConfigProperties.getTokenPrefix() + "=" + jwtToken);
            }
            Throwable throwable = null;
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
                int httpResponseCode = response.getStatusLine().getStatusCode();
                if (httpResponseCode == 204) {
                    return;
                }
                try {
                    String obtainedMessage = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (httpResponseCode == 401) {
                        throw new ZaasClientException(ZaasClientErrorCodes.EXPIRED_JWT_EXCEPTION, obtainedMessage);
                    }
                    throw new ZaasClientException(ZaasClientErrorCodes.INVALID_JWT_TOKEN, obtainedMessage);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    private Optional<String> getJwtTokenFromRequest(@NonNull HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Optional<String> fromCookie = this.getJwtTokenFromCookie(request);
        return fromCookie.isPresent() ? fromCookie : this.extractJwtTokenFromAuthorizationHeader(request.getHeader("Authorization"));
    }

    private Optional<String> getJwtTokenFromCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return Optional.empty();
        }
        return Arrays.stream(cookies).filter(cookie -> cookie.getName().equals(this.zassConfigProperties.getTokenPrefix())).filter(cookie -> !cookie.getValue().isEmpty()).findFirst().map(Cookie::getValue);
    }

    private Optional<String> extractJwtTokenFromAuthorizationHeader(String header) {
        if (header != null && header.startsWith(BEARER_AUTHENTICATION_PREFIX)) {
            if ((header = header.replaceFirst(BEARER_AUTHENTICATION_PREFIX, "").trim()).isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(header);
        }
        return Optional.empty();
    }

    private void clearZaasClientCookies() {
        if (this.httpClientProvider instanceof ZaasHttpsClientProvider) {
            ((ZaasHttpsClientProvider)this.httpClientProvider).clearCookieStore();
        }
    }

    private void handleErrorMessage(JsonNode message, Predicate<ZaasClientErrorCodes> condition) throws ZaasClientException {
        String messageNumber;
        ZaasClientErrorCodes zaasClientErrorCode;
        JsonNode messageNumberNode = message.get("messageNumber");
        if (messageNumberNode != null && messageNumberNode.getNodeType() == JsonNodeType.STRING && condition.test(zaasClientErrorCode = ZaasClientErrorCodes.byErrorNumber(messageNumber = messageNumberNode.asText()))) {
            throw new ZaasClientException(zaasClientErrorCode, zaasClientErrorCode.getMessage());
        }
    }

    private void handleErrorMessage(String errorMessage, Predicate<ZaasClientErrorCodes> condition) throws ZaasClientException, IOException {
        if (errorMessage == null) {
            return;
        }
        JsonNode jsonNode = this.objectMapper.readTree(errorMessage);
        JsonNode messages = jsonNode.get("messages");
        if (messages != null && messages.getNodeType() == JsonNodeType.ARRAY) {
            ArrayNode messagesArray = (ArrayNode)messages;
            for (JsonNode message : messagesArray) {
                this.handleErrorMessage(message, condition);
            }
        }
    }

    private ZaasToken extractZaasToken(CloseableHttpResponse response) throws IOException, ZaasClientException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            ZaasToken token = (ZaasToken)this.objectMapper.readValue(response.getEntity().getContent(), ZaasToken.class);
            if (token == null) {
                throw new ZaasClientException(ZaasClientErrorCodes.TOKEN_NOT_PROVIDED, "Queried token is null");
            }
            if (token.isExpired()) {
                throw new ZaasClientException(ZaasClientErrorCodes.EXPIRED_JWT_EXCEPTION, "Queried token is expired");
            }
            return token;
        }
        String obtainedMessage = EntityUtils.toString((HttpEntity)response.getEntity());
        if (statusCode == 401) {
            this.handleErrorMessage(obtainedMessage, ZaasClientErrorCodes.EXPIRED_PASSWORD::equals);
            throw new ZaasClientException(ZaasClientErrorCodes.INVALID_JWT_TOKEN, "Queried token is invalid or expired");
        }
        throw new ZaasClientException(ZaasClientErrorCodes.GENERIC_EXCEPTION, obtainedMessage);
    }

    private String extractToken(CloseableHttpResponse response) throws ZaasClientException, IOException {
        String token = "";
        int httpResponseCode = response.getStatusLine().getStatusCode();
        if (httpResponseCode == 204) {
            HeaderElement[] elements = response.getHeaders("Set-Cookie")[0].getElements();
            Optional<HeaderElement> apimlAuthCookie = Stream.of(elements).filter(element -> element.getName().equals(this.zassConfigProperties.getTokenPrefix())).findFirst();
            if (apimlAuthCookie.isPresent()) {
                token = apimlAuthCookie.get().getValue();
            }
            return token;
        }
        String obtainedMessage = EntityUtils.toString((HttpEntity)response.getEntity());
        if (httpResponseCode == 401) {
            this.handleErrorMessage(obtainedMessage, ZaasClientErrorCodes.EXPIRED_PASSWORD::equals);
            throw new ZaasClientException(ZaasClientErrorCodes.INVALID_AUTHENTICATION, obtainedMessage);
        }
        if (httpResponseCode == 400) {
            throw new ZaasClientException(ZaasClientErrorCodes.EMPTY_NULL_USERNAME_PASSWORD, obtainedMessage);
        }
        throw new ZaasClientException(ZaasClientErrorCodes.GENERIC_EXCEPTION, obtainedMessage);
    }

    private ZaasClientException handleException(Exception e) {
        if (e instanceof ZaasClientException) {
            return (ZaasClientException)e;
        }
        if (e instanceof IOException) {
            return new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, (Throwable)e);
        }
        if (e instanceof ZaasConfigurationException) {
            return new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, (Throwable)e);
        }
        return new ZaasClientException(ZaasClientErrorCodes.GENERIC_EXCEPTION, (Throwable)e);
    }

    static interface Token {
        public Object extract(CloseableHttpResponse var1) throws IOException, ZaasClientException;
    }

    static class Credentials {
        String username;
        char[] password;
        char[] newPassword;

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public char[] getPassword() {
            return this.password;
        }

        @Generated
        public char[] getNewPassword() {
            return this.newPassword;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setPassword(char[] password) {
            this.password = password;
        }

        @Generated
        public void setNewPassword(char[] newPassword) {
            this.newPassword = newPassword;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Credentials)) {
                return false;
            }
            Credentials other = (Credentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            if (!Arrays.equals(this.getPassword(), other.getPassword())) {
                return false;
            }
            return Arrays.equals(this.getNewPassword(), other.getNewPassword());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Credentials;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            result = result * 59 + Arrays.hashCode(this.getPassword());
            result = result * 59 + Arrays.hashCode(this.getNewPassword());
            return result;
        }

        @Generated
        public String toString() {
            return "ZaasJwtService.Credentials(username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", newPassword=" + Arrays.toString(this.getNewPassword()) + ")";
        }

        @Generated
        public Credentials(String username, char[] password, char[] newPassword) {
            this.username = username;
            this.password = password;
            this.newPassword = newPassword;
        }
    }
}

