/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.service.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import lombok.NonNull;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.zaasclient.config.ConfigProperties;
import org.zowe.apiml.zaasclient.exception.ZaasClientErrorCodes;
import org.zowe.apiml.zaasclient.exception.ZaasClientException;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationException;
import org.zowe.apiml.zaasclient.service.ZaasToken;
import org.zowe.apiml.zaasclient.service.internal.CloseableClientProvider;
import org.zowe.apiml.zaasclient.service.internal.TokenService;
import org.zowe.apiml.zaasclient.service.internal.ZaasHttpsClientProvider;

class ZaasJwtService
implements TokenService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZaasJwtService.class);
    private static final String BEARER_AUTHENTICATION_PREFIX = "Bearer";
    private final String loginEndpoint;
    private final String queryEndpoint;
    private final String logoutEndpoint;
    private final CloseableClientProvider httpClientProvider;
    private final ObjectMapper objectMapper = new ObjectMapper();
    ConfigProperties zassConfigProperties;

    public ZaasJwtService(CloseableClientProvider client, String baseUrl, ConfigProperties configProperties) {
        this.httpClientProvider = client;
        this.loginEndpoint = baseUrl + "/login";
        this.queryEndpoint = baseUrl + "/query";
        this.logoutEndpoint = baseUrl + "/logout";
        this.zassConfigProperties = configProperties;
    }

    @Override
    public String login(String userId, char[] password, char[] newPassword) throws ZaasClientException {
        return (String)this.doRequest(() -> this.loginWithCredentials(userId, password, newPassword), this::extractToken);
    }

    @Override
    public String login(String userId, char[] password) throws ZaasClientException {
        return (String)this.doRequest(() -> this.loginWithCredentials(userId, password, null), this::extractToken);
    }

    private ClientWithResponse loginWithCredentials(String userId, char[] password, char[] newPassword) throws ZaasConfigurationException, IOException {
        CloseableHttpClient client = this.httpClientProvider.getHttpClient();
        HttpPost httpPost = new HttpPost(this.loginEndpoint);
        String json = this.objectMapper.writeValueAsString((Object)new Credentials(userId, password, newPassword));
        StringEntity entity = new StringEntity(json);
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeader("Content-Type", "application/json");
        return new ClientWithResponse(client, client.execute((HttpUriRequest)httpPost));
    }

    @Override
    public String login(String authorizationHeader) throws ZaasClientException {
        return (String)this.doRequest(() -> this.loginWithHeader(authorizationHeader), this::extractToken);
    }

    private ClientWithResponse loginWithHeader(String authorizationHeader) throws ZaasConfigurationException, IOException {
        CloseableHttpClient client = this.httpClientProvider.getHttpClient();
        HttpPost httpPost = new HttpPost(this.loginEndpoint);
        httpPost.setHeader("Authorization", authorizationHeader);
        return new ClientWithResponse(client, client.execute((HttpUriRequest)httpPost));
    }

    @Override
    public ZaasToken query(String jwtToken) throws ZaasClientException {
        if (jwtToken == null || jwtToken.isEmpty()) {
            throw new ZaasClientException(ZaasClientErrorCodes.TOKEN_NOT_PROVIDED, "No token provided");
        }
        return (ZaasToken)this.doRequest(() -> this.queryWithJwtToken(jwtToken), this::extractZaasToken);
    }

    @Override
    public ZaasToken query(@NonNull HttpServletRequest request) throws ZaasClientException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Optional<String> jwtToken = this.getJwtTokenFromRequest(request);
        return this.query((String)jwtToken.orElse(null));
    }

    @Override
    public void logout(String jwtToken) throws ZaasClientException {
        this.doRequest(() -> this.logoutJwtToken(jwtToken));
    }

    private Optional<String> getJwtTokenFromRequest(@NonNull HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Optional<String> fromCookie = this.getJwtTokenFromCookie(request);
        return fromCookie.isPresent() ? fromCookie : this.extractJwtTokenFromAuthorizationHeader(request.getHeader("Authorization"));
    }

    private Optional<String> getJwtTokenFromCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return Optional.empty();
        }
        return Arrays.stream(cookies).filter(cookie -> cookie.getName().equals(this.zassConfigProperties.getTokenPrefix())).filter(cookie -> !cookie.getValue().isEmpty()).findFirst().map(Cookie::getValue);
    }

    private Optional<String> extractJwtTokenFromAuthorizationHeader(String header) {
        if (header != null && header.startsWith(BEARER_AUTHENTICATION_PREFIX)) {
            if ((header = header.replaceFirst(BEARER_AUTHENTICATION_PREFIX, "").trim()).isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(header);
        }
        return Optional.empty();
    }

    private ClientWithResponse queryWithJwtToken(String jwtToken) throws ZaasConfigurationException, IOException {
        CloseableHttpClient client = this.httpClientProvider.getHttpClient();
        HttpGet httpGet = new HttpGet(this.queryEndpoint);
        httpGet.addHeader("Cookie", this.zassConfigProperties.getTokenPrefix() + "=" + jwtToken);
        return new ClientWithResponse(client, client.execute((HttpUriRequest)httpGet));
    }

    private ClientWithResponse logoutJwtToken(String jwtToken) throws ZaasConfigurationException, IOException, ZaasClientException {
        CloseableHttpClient client = this.httpClientProvider.getHttpClient();
        this.clearZaasClientCookies();
        HttpPost httpPost = new HttpPost(this.logoutEndpoint);
        if (jwtToken.startsWith(BEARER_AUTHENTICATION_PREFIX)) {
            httpPost.addHeader("Authorization", jwtToken);
        } else {
            httpPost.addHeader("Cookie", this.zassConfigProperties.getTokenPrefix() + "=" + jwtToken);
        }
        return this.getClientWithResponse(client, httpPost);
    }

    private void clearZaasClientCookies() {
        if (this.httpClientProvider instanceof ZaasHttpsClientProvider) {
            ((ZaasHttpsClientProvider)this.httpClientProvider).clearCookieStore();
        }
    }

    private ClientWithResponse getClientWithResponse(CloseableHttpClient client, HttpPost httpPost) throws IOException, ZaasClientException {
        ClientWithResponse clientWithResponse = new ClientWithResponse(client, client.execute((HttpUriRequest)httpPost));
        int httpResponseCode = clientWithResponse.getResponse().getStatusLine().getStatusCode();
        if (httpResponseCode == 204) {
            return clientWithResponse;
        }
        String obtainedMessage = EntityUtils.toString((HttpEntity)clientWithResponse.getResponse().getEntity());
        if (httpResponseCode == 401) {
            throw new ZaasClientException(ZaasClientErrorCodes.EXPIRED_JWT_EXCEPTION, obtainedMessage);
        }
        throw new ZaasClientException(ZaasClientErrorCodes.INVALID_JWT_TOKEN, obtainedMessage);
    }

    private void finallyClose(CloseableHttpResponse response) {
        try {
            if (response != null) {
                response.close();
            }
        }
        catch (IOException e) {
            log.warn("It wasn't possible to close the resources. " + e.getMessage());
        }
    }

    private void handleErrorMessage(JsonNode message, Predicate<ZaasClientErrorCodes> condition) throws ZaasClientException {
        String messageNumber;
        ZaasClientErrorCodes zaasClientErrorCode;
        JsonNode messageNumberNode = message.get("messageNumber");
        if (messageNumberNode != null && messageNumberNode.getNodeType() == JsonNodeType.STRING && condition.test(zaasClientErrorCode = ZaasClientErrorCodes.byErrorNumber(messageNumber = messageNumberNode.asText()))) {
            throw new ZaasClientException(zaasClientErrorCode, zaasClientErrorCode.getMessage());
        }
    }

    private void handleErrorMessage(String errorMessage, Predicate<ZaasClientErrorCodes> condition) throws ZaasClientException, IOException {
        if (errorMessage == null) {
            return;
        }
        JsonNode jsonNode = this.objectMapper.readTree(errorMessage);
        JsonNode messages = jsonNode.get("messages");
        if (messages != null && messages.getNodeType() == JsonNodeType.ARRAY) {
            ArrayNode messagesArray = (ArrayNode)messages;
            for (JsonNode message : messagesArray) {
                this.handleErrorMessage(message, condition);
            }
        }
    }

    private ZaasToken extractZaasToken(CloseableHttpResponse response) throws IOException, ZaasClientException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            ZaasToken token = (ZaasToken)this.objectMapper.readValue(response.getEntity().getContent(), ZaasToken.class);
            if (token == null) {
                throw new ZaasClientException(ZaasClientErrorCodes.TOKEN_NOT_PROVIDED, "Queried token is null");
            }
            if (token.isExpired()) {
                throw new ZaasClientException(ZaasClientErrorCodes.EXPIRED_JWT_EXCEPTION, "Queried token is expired");
            }
            return token;
        }
        String obtainedMessage = EntityUtils.toString((HttpEntity)response.getEntity());
        if (statusCode == 401) {
            this.handleErrorMessage(obtainedMessage, ZaasClientErrorCodes.EXPIRED_PASSWORD::equals);
            throw new ZaasClientException(ZaasClientErrorCodes.INVALID_JWT_TOKEN, "Queried token is invalid or expired");
        }
        throw new ZaasClientException(ZaasClientErrorCodes.GENERIC_EXCEPTION, obtainedMessage);
    }

    private String extractToken(CloseableHttpResponse response) throws ZaasClientException, IOException {
        String token = "";
        int httpResponseCode = response.getStatusLine().getStatusCode();
        if (httpResponseCode == 204) {
            HeaderElement[] elements = response.getHeaders("Set-Cookie")[0].getElements();
            Optional<HeaderElement> apimlAuthCookie = Stream.of(elements).filter(element -> element.getName().equals(this.zassConfigProperties.getTokenPrefix())).findFirst();
            if (apimlAuthCookie.isPresent()) {
                token = apimlAuthCookie.get().getValue();
            }
            return token;
        }
        String obtainedMessage = EntityUtils.toString((HttpEntity)response.getEntity());
        if (httpResponseCode == 401) {
            this.handleErrorMessage(obtainedMessage, ZaasClientErrorCodes.EXPIRED_PASSWORD::equals);
            throw new ZaasClientException(ZaasClientErrorCodes.INVALID_AUTHENTICATION, obtainedMessage);
        }
        if (httpResponseCode == 400) {
            throw new ZaasClientException(ZaasClientErrorCodes.EMPTY_NULL_USERNAME_PASSWORD, obtainedMessage);
        }
        throw new ZaasClientException(ZaasClientErrorCodes.GENERIC_EXCEPTION, obtainedMessage);
    }

    private void doRequest(Operation request) throws ZaasClientException {
        ClientWithResponse clientWithResponse = new ClientWithResponse();
        try {
            clientWithResponse = request.request();
        }
        catch (IOException | ZaasConfigurationException e) {
            throw new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, (Throwable)e);
        }
        finally {
            this.finallyClose(clientWithResponse.getResponse());
        }
    }

    private Object doRequest(Operation request, Token token) throws ZaasClientException {
        ClientWithResponse clientWithResponse = new ClientWithResponse();
        try {
            clientWithResponse = request.request();
            Object object = token.extract(clientWithResponse.getResponse());
            return object;
        }
        catch (ZaasClientException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, (Throwable)e);
        }
        catch (Exception e) {
            throw new ZaasClientException(ZaasClientErrorCodes.GENERIC_EXCEPTION, (Throwable)e);
        }
        finally {
            this.finallyClose(clientWithResponse.getResponse());
        }
    }

    static interface Operation {
        public ClientWithResponse request() throws ZaasConfigurationException, IOException, ZaasClientException;
    }

    static interface Token {
        public Object extract(CloseableHttpResponse var1) throws IOException, ZaasClientException;
    }

    static class ClientWithResponse {
        CloseableHttpClient client;
        CloseableHttpResponse response;

        @Generated
        public CloseableHttpClient getClient() {
            return this.client;
        }

        @Generated
        public CloseableHttpResponse getResponse() {
            return this.response;
        }

        @Generated
        public void setClient(CloseableHttpClient client) {
            this.client = client;
        }

        @Generated
        public void setResponse(CloseableHttpResponse response) {
            this.response = response;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientWithResponse)) {
                return false;
            }
            ClientWithResponse other = (ClientWithResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CloseableHttpClient this$client = this.getClient();
            CloseableHttpClient other$client = other.getClient();
            if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
                return false;
            }
            CloseableHttpResponse this$response = this.getResponse();
            CloseableHttpResponse other$response = other.getResponse();
            return !(this$response == null ? other$response != null : !this$response.equals(other$response));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClientWithResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CloseableHttpClient $client = this.getClient();
            result = result * 59 + ($client == null ? 43 : $client.hashCode());
            CloseableHttpResponse $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : $response.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ZaasJwtService.ClientWithResponse(client=" + this.getClient() + ", response=" + this.getResponse() + ")";
        }

        @Generated
        public ClientWithResponse(CloseableHttpClient client, CloseableHttpResponse response) {
            this.client = client;
            this.response = response;
        }

        @Generated
        public ClientWithResponse() {
        }
    }

    static class Credentials {
        String username;
        char[] password;
        char[] newPassword;

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public char[] getPassword() {
            return this.password;
        }

        @Generated
        public char[] getNewPassword() {
            return this.newPassword;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setPassword(char[] password) {
            this.password = password;
        }

        @Generated
        public void setNewPassword(char[] newPassword) {
            this.newPassword = newPassword;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Credentials)) {
                return false;
            }
            Credentials other = (Credentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            if (!Arrays.equals(this.getPassword(), other.getPassword())) {
                return false;
            }
            return Arrays.equals(this.getNewPassword(), other.getNewPassword());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Credentials;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            result = result * 59 + Arrays.hashCode(this.getPassword());
            result = result * 59 + Arrays.hashCode(this.getNewPassword());
            return result;
        }

        @Generated
        public String toString() {
            return "ZaasJwtService.Credentials(username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", newPassword=" + Arrays.toString(this.getNewPassword()) + ")";
        }

        @Generated
        public Credentials(String username, char[] password, char[] newPassword) {
            this.username = username;
            this.password = password;
            this.newPassword = newPassword;
        }
    }
}

