/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.service.internal;

import java.util.Arrays;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.zowe.apiml.zaasclient.config.ConfigProperties;
import org.zowe.apiml.zaasclient.exception.ZaasClientErrorCodes;
import org.zowe.apiml.zaasclient.exception.ZaasClientException;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationErrorCodes;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationException;
import org.zowe.apiml.zaasclient.service.ZaasClient;
import org.zowe.apiml.zaasclient.service.ZaasToken;
import org.zowe.apiml.zaasclient.service.internal.CloseableClientProvider;
import org.zowe.apiml.zaasclient.service.internal.PassTicketService;
import org.zowe.apiml.zaasclient.service.internal.PassTicketServiceImpl;
import org.zowe.apiml.zaasclient.service.internal.TokenService;
import org.zowe.apiml.zaasclient.service.internal.ZaasHttpClientProvider;
import org.zowe.apiml.zaasclient.service.internal.ZaasHttpsClientProvider;
import org.zowe.apiml.zaasclient.service.internal.ZaasJwtService;

public class ZaasClientImpl
implements ZaasClient {
    private final TokenService tokens;
    private final PassTicketService passTickets;

    public ZaasClientImpl(ConfigProperties configProperties) throws ZaasConfigurationException {
        if (!configProperties.isHttpOnly() && configProperties.getKeyStorePath() == null) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.KEY_STORE_NOT_PROVIDED);
        }
        CloseableClientProvider httpClientProvider = this.getTokenProvider(configProperties);
        CloseableClientProvider httpClientProviderWithoutCert = this.getTokenProviderWithoutCert(configProperties, httpClientProvider);
        String baseUrl = String.format("%s://%s:%s%s", this.getScheme(configProperties.isHttpOnly()), configProperties.getApimlHost(), configProperties.getApimlPort(), configProperties.getApimlBaseUrl());
        this.tokens = new ZaasJwtService(httpClientProviderWithoutCert, baseUrl);
        this.passTickets = new PassTicketServiceImpl(httpClientProvider, baseUrl);
    }

    private CloseableClientProvider getTokenProvider(ConfigProperties configProperties) throws ZaasConfigurationException {
        if (configProperties.isHttpOnly()) {
            return new ZaasHttpClientProvider();
        }
        return new ZaasHttpsClientProvider(configProperties);
    }

    private CloseableClientProvider getTokenProviderWithoutCert(ConfigProperties configProperties, CloseableClientProvider defaultCloseableClientProvider) throws ZaasConfigurationException {
        if (configProperties.isHttpOnly()) {
            return defaultCloseableClientProvider;
        }
        return this.getTokenProvider(configProperties.withoutKeyStore());
    }

    private Object getScheme(boolean httpOnly) {
        if (httpOnly) {
            return "http";
        }
        return "https";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String login(String userId, String password, String newPassword) throws ZaasClientException {
        char[] pass = password == null ? null : password.toCharArray();
        char[] newPass = newPassword == null ? null : newPassword.toCharArray();
        try {
            String string = this.login(userId, pass, newPass);
            return string;
        }
        finally {
            if (pass != null) {
                Arrays.fill(pass, '\u0000');
            }
            if (newPass != null) {
                Arrays.fill(newPass, '\u0000');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String login(String userId, String password) throws ZaasClientException {
        char[] pass = password == null ? null : password.toCharArray();
        try {
            String string = this.login(userId, pass);
            return string;
        }
        finally {
            if (pass != null) {
                Arrays.fill(pass, '\u0000');
            }
        }
    }

    @Override
    public String login(String userId, char[] password, char[] newPassword) throws ZaasClientException {
        if (userId == null || password == null || newPassword == null || userId.isEmpty() || password.length == 0 || newPassword.length == 0) {
            throw new ZaasClientException(ZaasClientErrorCodes.EMPTY_NULL_USERNAME_PASSWORD);
        }
        return this.tokens.login(userId, password, newPassword);
    }

    @Override
    public String login(String userId, char[] password) throws ZaasClientException {
        if (userId == null || password == null || userId.isEmpty() || password.length == 0) {
            throw new ZaasClientException(ZaasClientErrorCodes.EMPTY_NULL_USERNAME_PASSWORD);
        }
        return this.tokens.login(userId, password);
    }

    @Override
    public String login(String authorizationHeader) throws ZaasClientException {
        if (authorizationHeader == null || authorizationHeader.isEmpty()) {
            throw new ZaasClientException(ZaasClientErrorCodes.EMPTY_NULL_AUTHORIZATION_HEADER);
        }
        return this.tokens.login(authorizationHeader);
    }

    @Override
    public ZaasToken query(String token) throws ZaasClientException {
        return this.tokens.query(token);
    }

    @Override
    public ZaasToken query(HttpServletRequest request) throws ZaasClientException {
        return this.tokens.query(request);
    }

    @Override
    public String passTicket(String jwtToken, String applicationId) throws ZaasClientException, ZaasConfigurationException {
        if (Objects.isNull(applicationId) || applicationId.isEmpty()) {
            throw new ZaasClientException(ZaasClientErrorCodes.APPLICATION_NAME_NOT_FOUND);
        }
        if (Objects.isNull(jwtToken) || jwtToken.isEmpty()) {
            throw new ZaasClientException(ZaasClientErrorCodes.TOKEN_NOT_PROVIDED);
        }
        return this.passTickets.passTicket(jwtToken, applicationId);
    }

    @Override
    public void logout(String jwtToken) throws ZaasConfigurationException, ZaasClientException {
        this.tokens.logout(jwtToken);
    }

    @Generated
    ZaasClientImpl(TokenService tokens, PassTicketService passTickets) {
        this.tokens = tokens;
        this.passTickets = passTickets;
    }
}

