/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.service.internal;

import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.zaasclient.config.ConfigProperties;
import org.zowe.apiml.zaasclient.exception.ZaasClientErrorCodes;
import org.zowe.apiml.zaasclient.exception.ZaasClientException;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationException;
import org.zowe.apiml.zaasclient.service.ZaasClient;
import org.zowe.apiml.zaasclient.service.ZaasToken;
import org.zowe.apiml.zaasclient.service.internal.HttpsClientProvider;
import org.zowe.apiml.zaasclient.service.internal.PassTicketService;
import org.zowe.apiml.zaasclient.service.internal.PassTicketServiceHttps;
import org.zowe.apiml.zaasclient.service.internal.TokenService;
import org.zowe.apiml.zaasclient.service.internal.TokenServiceHttpsJwt;

public class ZaasClientHttps
implements ZaasClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZaasClientHttps.class);
    private TokenService tokens;
    private PassTicketService passTickets;

    public ZaasClientHttps(ConfigProperties configProperties) throws ZaasConfigurationException {
        try {
            HttpsClientProvider provider = new HttpsClientProvider(configProperties);
            String baseUrl = String.format("https://%s:%s%s", configProperties.getApimlHost(), configProperties.getApimlPort(), configProperties.getApimlBaseUrl());
            this.tokens = new TokenServiceHttpsJwt(provider, baseUrl);
            this.passTickets = new PassTicketServiceHttps(provider, baseUrl);
        }
        catch (ZaasConfigurationException e) {
            log.error(e.getErrorCode().toString());
            throw e;
        }
    }

    ZaasClientHttps(TokenService tokens, PassTicketService passTickets) {
        this.tokens = tokens;
        this.passTickets = passTickets;
    }

    @Override
    public String login(String userId, String password) throws ZaasClientException {
        if (userId == null || password == null || userId.isEmpty() || password.isEmpty()) {
            log.error(ZaasClientErrorCodes.EMPTY_NULL_USERNAME_PASSWORD.toString());
            throw new ZaasClientException(ZaasClientErrorCodes.EMPTY_NULL_USERNAME_PASSWORD);
        }
        try {
            return this.tokens.login(userId, password);
        }
        catch (ZaasClientException e) {
            log.error(e.getErrorCode().toString());
            throw e;
        }
    }

    @Override
    public String login(String authorizationHeader) throws ZaasClientException {
        if (authorizationHeader == null || authorizationHeader.isEmpty()) {
            throw new ZaasClientException(ZaasClientErrorCodes.EMPTY_NULL_AUTHORIZATION_HEADER);
        }
        try {
            return this.tokens.login(authorizationHeader);
        }
        catch (ZaasClientException e) {
            log.error(e.getErrorCode().toString());
            throw e;
        }
    }

    @Override
    public ZaasToken query(String token) throws ZaasClientException {
        try {
            return this.tokens.query(token);
        }
        catch (ZaasClientException e) {
            log.error(e.getErrorCode().toString());
            throw e;
        }
    }

    @Override
    public String passTicket(String jwtToken, String applicationId) throws ZaasClientException, ZaasConfigurationException {
        if (Objects.isNull(applicationId) || applicationId.isEmpty()) {
            throw new ZaasClientException(ZaasClientErrorCodes.APPLICATION_NAME_NOT_FOUND);
        }
        if (Objects.isNull(jwtToken) || jwtToken.isEmpty()) {
            throw new ZaasClientException(ZaasClientErrorCodes.TOKEN_NOT_PROVIDED);
        }
        try {
            return this.passTickets.passTicket(jwtToken, applicationId);
        }
        catch (ZaasClientException e) {
            log.error(e.getErrorCode().toString());
            throw e;
        }
        catch (ZaasConfigurationException e) {
            log.error(e.getErrorCode().toString());
            throw e;
        }
    }
}

