/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.client.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.zowe.apiml.product.gateway.GatewayClient;
import org.zowe.apiml.product.instance.ServiceAddress;
import org.zowe.apiml.security.client.handler.RestResponseHandler;
import org.zowe.apiml.security.client.service.GatewaySecurity;
import org.zowe.apiml.security.common.config.AuthConfigurationProperties;
import org.zowe.apiml.security.common.error.ErrorType;
import org.zowe.apiml.security.common.login.LoginRequest;
import org.zowe.apiml.security.common.token.QueryResponse;
import org.zowe.apiml.util.UrlUtils;

@Service
public class GatewaySecurityService
implements GatewaySecurity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GatewaySecurityService.class);
    private static final String MESSAGE_KEY_STRING = "messageKey\":\"";
    private final GatewayClient gatewayClient;
    private final AuthConfigurationProperties authConfigurationProperties;
    private final CloseableHttpClient closeableHttpClient;
    private final RestResponseHandler responseHandler;
    private final ObjectMapper objectMapper = new ObjectMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> login(String username, char[] password, char[] newPassword) {
        ServiceAddress gatewayConfigProperties = this.gatewayClient.getGatewayConfigProperties();
        String uri = UrlUtils.getUrl((String)gatewayConfigProperties.getScheme(), (String)gatewayConfigProperties.getHostname()) + this.authConfigurationProperties.getGatewayLoginEndpoint();
        LoginRequest loginRequest = new LoginRequest(username, password);
        if (!ArrayUtils.isEmpty((char[])newPassword)) {
            loginRequest.setNewPassword(newPassword);
        }
        try {
            HttpPost post = new HttpPost(uri);
            String json = this.objectMapper.writeValueAsString((Object)loginRequest);
            post.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            Optional optional = (Optional)this.closeableHttpClient.execute((ClassicHttpRequest)post, response -> {
                if (!HttpStatus.valueOf((int)response.getCode()).is2xxSuccessful()) {
                    HttpEntity responseEntity = response.getEntity();
                    String responseBody = null;
                    if (responseEntity != null) {
                        responseBody = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
                    }
                    ErrorType errorType = this.getErrorType(responseBody);
                    this.responseHandler.handleErrorType((HttpResponse)response, errorType, "Cannot access Gateway service. Uri '{}' returned: {}", uri);
                    return Optional.empty();
                }
                return this.extractToken(response.getFirstHeader("Set-Cookie").getValue());
            });
            return optional;
        }
        catch (IOException e) {
            this.responseHandler.handleException(e);
        }
        finally {
            loginRequest.evictSensitiveData();
        }
        return Optional.empty();
    }

    @Override
    public QueryResponse query(String token) {
        ServiceAddress gatewayConfigProperties = this.gatewayClient.getGatewayConfigProperties();
        String uri = UrlUtils.getUrl((String)gatewayConfigProperties.getScheme(), (String)gatewayConfigProperties.getHostname()) + this.authConfigurationProperties.getGatewayQueryEndpoint();
        String cookie = String.format("%s=%s", this.authConfigurationProperties.getCookieProperties().getCookieName(), token);
        try {
            HttpGet get = new HttpGet(uri);
            get.addHeader("Cookie", (Object)cookie);
            return (QueryResponse)this.closeableHttpClient.execute((ClassicHttpRequest)get, response -> {
                HttpEntity responseEntity = response.getEntity();
                String responseBody = null;
                if (responseEntity != null) {
                    responseBody = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
                }
                if (!HttpStatus.valueOf((int)response.getCode()).is2xxSuccessful()) {
                    log.debug("Cannot access Gateway service to verify JWT token. Uri '{}' returned: {}", (Object)uri, (Object)response);
                    ErrorType errorType = this.getErrorType(responseBody);
                    this.responseHandler.handleErrorType((HttpResponse)response, errorType, uri);
                    return null;
                }
                return (QueryResponse)this.objectMapper.readValue(responseBody, QueryResponse.class);
            });
        }
        catch (IOException e) {
            this.responseHandler.handleException(e);
            return null;
        }
    }

    @Override
    public QueryResponse verifyOidc(String token) {
        ServiceAddress gatewayConfigProperties = this.gatewayClient.getGatewayConfigProperties();
        String uri = UrlUtils.getUrl((String)gatewayConfigProperties.getScheme(), (String)gatewayConfigProperties.getHostname()) + this.authConfigurationProperties.getGatewayOidcValidateEndpoint();
        try {
            HttpPost post = new HttpPost(uri);
            post.setEntity((HttpEntity)new StringEntity(this.objectMapper.writeValueAsString((Object)new TokenRequest(token)), ContentType.APPLICATION_JSON));
            return (QueryResponse)this.closeableHttpClient.execute((ClassicHttpRequest)post, response -> {
                HttpEntity responseEntity = response.getEntity();
                String responseBody = null;
                if (responseEntity != null) {
                    responseBody = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
                }
                if (!HttpStatus.valueOf((int)response.getCode()).is2xxSuccessful()) {
                    log.debug("Cannot access Gateway service to verify OIDC token. Uri '{}' returned: {}", (Object)uri, (Object)response);
                    ErrorType errorType = this.getErrorType(responseBody);
                    this.responseHandler.handleErrorType((HttpResponse)response, errorType, uri);
                    return null;
                }
                return new QueryResponse();
            });
        }
        catch (IOException e) {
            this.responseHandler.handleException(e);
            return null;
        }
    }

    private ErrorType getErrorType(String detailMessage) {
        if (detailMessage == null) {
            return ErrorType.AUTH_GENERAL;
        }
        int indexOfMessageKey = detailMessage.indexOf(MESSAGE_KEY_STRING);
        if (indexOfMessageKey < 0) {
            return ErrorType.AUTH_GENERAL;
        }
        String messageKeyToEndOfExceptionMessage = detailMessage.substring(indexOfMessageKey + MESSAGE_KEY_STRING.length());
        String messageKey = messageKeyToEndOfExceptionMessage.substring(0, messageKeyToEndOfExceptionMessage.indexOf("\""));
        try {
            return ErrorType.fromMessageKey((String)messageKey);
        }
        catch (IllegalArgumentException e) {
            return ErrorType.AUTH_GENERAL;
        }
    }

    private Optional<String> extractToken(String cookies) {
        String cookieName = this.authConfigurationProperties.getCookieProperties().getCookieName();
        if (cookies == null || cookies.isEmpty() || !cookies.contains(cookieName)) {
            return Optional.empty();
        }
        int end = cookies.indexOf(59);
        String cookie = end > 0 ? cookies.substring(0, end) : cookies;
        return Optional.of(cookie.replace(cookieName + "=", ""));
    }

    @Generated
    public GatewaySecurityService(GatewayClient gatewayClient, AuthConfigurationProperties authConfigurationProperties, CloseableHttpClient closeableHttpClient, RestResponseHandler responseHandler) {
        this.gatewayClient = gatewayClient;
        this.authConfigurationProperties = authConfigurationProperties;
        this.closeableHttpClient = closeableHttpClient;
        this.responseHandler = responseHandler;
    }

    static class TokenRequest {
        String token;

        @Generated
        public String getToken() {
            return this.token;
        }

        @Generated
        public void setToken(String token) {
            this.token = token;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenRequest)) {
                return false;
            }
            TokenRequest other = (TokenRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            return !(this$token == null ? other$token != null : !this$token.equals(other$token));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TokenRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GatewaySecurityService.TokenRequest(token=" + this.getToken() + ")";
        }

        @Generated
        public TokenRequest(String token) {
            this.token = token;
        }
    }
}

