/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.client.token;

import lombok.Generated;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.zowe.apiml.security.client.service.GatewaySecurityService;
import org.zowe.apiml.security.common.token.QueryResponse;
import org.zowe.apiml.security.common.token.TokenAuthentication;

@Component
public class GatewayTokenProvider
implements AuthenticationProvider {
    private final GatewaySecurityService gatewaySecurityService;

    public Authentication authenticate(Authentication authentication) {
        TokenAuthentication tokenAuthentication = (TokenAuthentication)authentication;
        QueryResponse queryResponse = tokenAuthentication.getType() == TokenAuthentication.Type.OIDC ? this.gatewaySecurityService.verifyOidc(tokenAuthentication.getCredentials()) : this.gatewaySecurityService.query(tokenAuthentication.getCredentials());
        TokenAuthentication validTokenAuthentication = new TokenAuthentication(queryResponse.getUserId(), tokenAuthentication.getCredentials(), tokenAuthentication.getType());
        validTokenAuthentication.setAuthenticated(true);
        return validTokenAuthentication;
    }

    public boolean supports(Class<?> authentication) {
        return TokenAuthentication.class.isAssignableFrom(authentication);
    }

    @Generated
    public GatewayTokenProvider(GatewaySecurityService gatewaySecurityService) {
        this.gatewaySecurityService = gatewaySecurityService;
    }
}

