/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.client.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.springframework.stereotype.Service;
import org.zowe.apiml.product.gateway.GatewayClient;
import org.zowe.apiml.product.instance.ServiceAddress;
import org.zowe.apiml.security.client.handler.RestResponseHandler;
import org.zowe.apiml.security.common.config.AuthConfigurationProperties;
import org.zowe.apiml.security.common.error.ErrorType;
import org.zowe.apiml.security.common.login.LoginRequest;
import org.zowe.apiml.security.common.token.QueryResponse;

@Service
public class GatewaySecurityService {
    private static final String MESSAGE_KEY_STRING = "messageKey\":\"";
    private final GatewayClient gatewayClient;
    private final AuthConfigurationProperties authConfigurationProperties;
    private final CloseableHttpClient closeableHttpClient;
    private final RestResponseHandler responseHandler;
    private final ObjectMapper objectMapper = new ObjectMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> login(String username, char[] password, char[] newPassword) {
        ServiceAddress gatewayConfigProperties = this.gatewayClient.getGatewayConfigProperties();
        String uri = String.format("%s://%s%s", gatewayConfigProperties.getScheme(), gatewayConfigProperties.getHostname(), this.authConfigurationProperties.getGatewayLoginEndpoint());
        LoginRequest loginRequest = new LoginRequest(username, password);
        if (!ArrayUtils.isEmpty((char[])newPassword)) {
            loginRequest.setNewPassword(newPassword);
        }
        try {
            HttpPost post = new HttpPost(uri);
            String json = this.objectMapper.writeValueAsString((Object)loginRequest);
            post.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            CloseableHttpResponse response = this.closeableHttpClient.execute((ClassicHttpRequest)post);
            int statusCode = response.getCode();
            if (statusCode < 200 || statusCode >= 300) {
                HttpEntity responseEntity = response.getEntity();
                String responseBody = null;
                if (responseEntity != null) {
                    responseBody = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
                }
                ErrorType errorType = this.getErrorType(responseBody);
                this.responseHandler.handleErrorType(response, errorType, "Cannot access Gateway service. Uri '{}' returned: {}", uri);
                Optional<String> optional = Optional.empty();
                return optional;
            }
            Optional<String> optional = this.extractToken(response.getFirstHeader("Set-Cookie").getValue());
            return optional;
        }
        catch (IOException | ParseException e) {
            this.responseHandler.handleException((Exception)e);
        }
        finally {
            loginRequest.evictSensitiveData();
        }
        return Optional.empty();
    }

    public QueryResponse query(String token) {
        ServiceAddress gatewayConfigProperties = this.gatewayClient.getGatewayConfigProperties();
        String uri = String.format("%s://%s%s", gatewayConfigProperties.getScheme(), gatewayConfigProperties.getHostname(), this.authConfigurationProperties.getGatewayQueryEndpoint());
        String cookie = String.format("%s=%s", this.authConfigurationProperties.getCookieProperties().getCookieName(), token);
        try {
            int statusCode;
            HttpGet get = new HttpGet(uri);
            get.addHeader("Cookie", (Object)cookie);
            CloseableHttpResponse response = this.closeableHttpClient.execute((ClassicHttpRequest)get);
            HttpEntity responseEntity = response.getEntity();
            String responseBody = null;
            if (responseEntity != null) {
                responseBody = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
            }
            if ((statusCode = response.getCode()) < 200 || statusCode >= 300) {
                ErrorType errorType = this.getErrorType(responseBody);
                this.responseHandler.handleErrorType(response, errorType, "Cannot access Gateway service. Uri '{}' returned: {}", uri);
                return null;
            }
            return (QueryResponse)this.objectMapper.readValue(responseBody, QueryResponse.class);
        }
        catch (IOException | ParseException e) {
            this.responseHandler.handleException((Exception)e);
            return null;
        }
    }

    private ErrorType getErrorType(String detailMessage) {
        if (detailMessage == null) {
            return ErrorType.AUTH_GENERAL;
        }
        int indexOfMessageKey = detailMessage.indexOf(MESSAGE_KEY_STRING);
        if (indexOfMessageKey < 0) {
            return ErrorType.AUTH_GENERAL;
        }
        String messageKeyToEndOfExceptionMessage = detailMessage.substring(indexOfMessageKey + MESSAGE_KEY_STRING.length());
        String messageKey = messageKeyToEndOfExceptionMessage.substring(0, messageKeyToEndOfExceptionMessage.indexOf("\""));
        try {
            return ErrorType.fromMessageKey((String)messageKey);
        }
        catch (IllegalArgumentException e) {
            return ErrorType.AUTH_GENERAL;
        }
    }

    private Optional<String> extractToken(String cookies) {
        String cookieName = this.authConfigurationProperties.getCookieProperties().getCookieName();
        if (cookies == null || cookies.isEmpty() || !cookies.contains(cookieName)) {
            return Optional.empty();
        }
        int end = cookies.indexOf(59);
        String cookie = end > 0 ? cookies.substring(0, end) : cookies;
        return Optional.of(cookie.replace(cookieName + "=", ""));
    }

    @Generated
    public GatewaySecurityService(GatewayClient gatewayClient, AuthConfigurationProperties authConfigurationProperties, CloseableHttpClient closeableHttpClient, RestResponseHandler responseHandler) {
        this.gatewayClient = gatewayClient;
        this.authConfigurationProperties = authConfigurationProperties;
        this.closeableHttpClient = closeableHttpClient;
        this.responseHandler = responseHandler;
    }
}

