/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.client.handler;

import java.io.IOException;
import lombok.Generated;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Component;
import org.zowe.apiml.product.gateway.GatewayNotAvailableException;
import org.zowe.apiml.security.common.auth.saf.PlatformReturned;
import org.zowe.apiml.security.common.error.AuthMethodNotSupportedException;
import org.zowe.apiml.security.common.error.ErrorType;
import org.zowe.apiml.security.common.error.ServiceNotAccessibleException;
import org.zowe.apiml.security.common.error.ZosAuthenticationException;
import org.zowe.apiml.security.common.token.InvalidTokenTypeException;
import org.zowe.apiml.security.common.token.TokenNotProvidedException;
import org.zowe.apiml.security.common.token.TokenNotValidException;

@Component
public class RestResponseHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestResponseHandler.class);

    public void handleErrorType(CloseableHttpResponse response, ErrorType errorType, Object ... logParameters) {
        switch (response.getStatusLine().getStatusCode()) {
            case 401: {
                if (errorType != null) {
                    if (errorType.equals((Object)ErrorType.BAD_CREDENTIALS)) {
                        throw new BadCredentialsException(errorType.getDefaultMessage());
                    }
                    if (errorType.equals((Object)ErrorType.TOKEN_NOT_VALID)) {
                        throw new TokenNotValidException(errorType.getDefaultMessage());
                    }
                    if (errorType.equals((Object)ErrorType.TOKEN_NOT_PROVIDED)) {
                        throw new TokenNotProvidedException(errorType.getDefaultMessage());
                    }
                    if (errorType.equals((Object)ErrorType.INVALID_TOKEN_TYPE)) {
                        throw new InvalidTokenTypeException(errorType.getDefaultMessage());
                    }
                    if (errorType.equals((Object)ErrorType.USER_SUSPENDED)) {
                        throw new ZosAuthenticationException(PlatformReturned.builder().errno(163).errnoMsg("org.zowe.apiml.security.platform.errno.EMVSSAFEXTRERR").build());
                    }
                    if (errorType.equals((Object)ErrorType.NEW_PASSWORD_INVALID)) {
                        throw new ZosAuthenticationException(PlatformReturned.builder().errno(169).errnoMsg("org.zowe.apiml.security.platform.errno.EMVSPASSWORD").build());
                    }
                    if (errorType.equals((Object)ErrorType.PASSWORD_EXPIRED)) {
                        throw new ZosAuthenticationException(PlatformReturned.builder().errno(168).errnoMsg("org.zowe.apiml.security.platform.errno.EMVSEXPIRE").build());
                    }
                }
                throw new BadCredentialsException(ErrorType.BAD_CREDENTIALS.getDefaultMessage());
            }
            case 400: {
                throw new AuthenticationCredentialsNotFoundException(ErrorType.AUTH_CREDENTIALS_NOT_FOUND.getDefaultMessage());
            }
            case 405: {
                throw new AuthMethodNotSupportedException(ErrorType.AUTH_METHOD_NOT_SUPPORTED.getDefaultMessage());
            }
            case 500: 
            case 503: {
                throw new ServiceNotAccessibleException(ErrorType.SERVICE_UNAVAILABLE.getDefaultMessage());
            }
        }
        this.addDebugMessage(null, ErrorType.AUTH_GENERAL.getDefaultMessage(), logParameters);
        throw new AuthenticationServiceException(ErrorType.AUTH_GENERAL.getDefaultMessage());
    }

    public void handleException(IOException exception) {
        throw new GatewayNotAvailableException(ErrorType.GATEWAY_NOT_AVAILABLE.getDefaultMessage(), (Throwable)exception);
    }

    private void addDebugMessage(Exception exception, String genericLogErrorMessage, Object ... logParameters) {
        if (genericLogErrorMessage != null) {
            if (logParameters.length > 0) {
                log.debug(genericLogErrorMessage, logParameters);
            } else {
                log.debug(genericLogErrorMessage, (Throwable)exception);
            }
        }
    }
}

