/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.enable.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.zowe.apiml.eurekaservice.client.ApiMediationClient;
import org.zowe.apiml.eurekaservice.client.config.ApiMediationServiceConfig;
import org.zowe.apiml.eurekaservice.client.impl.ApiMediationClientImpl;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.yaml.YamlMessageService;
import org.zowe.apiml.message.yaml.YamlMessageServiceInstance;

@Configuration
@ComponentScan(value={"org.zowe.apiml.enable"})
public class EnableApiDiscoveryConfig {
    @Value(value="${apiml.enabled:false}")
    private boolean enabled;

    @Bean
    public MessageService messageServiceDiscovery() {
        YamlMessageService messageService = YamlMessageServiceInstance.getInstance();
        messageService.loadMessages("/onboarding-enabler-spring-messages.yml");
        return messageService;
    }

    @Bean
    public ApiMediationClient apiMediationClient() {
        return new ApiMediationClientImpl();
    }

    @ConfigurationProperties(prefix="apiml.service")
    @Bean
    public ApiMediationServiceConfig apiMediationServiceConfig() {
        return new ApiMediationServiceConfig();
    }

    @Bean
    public Boolean apimlEnabled() {
        return this.enabled;
    }
}

