/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.eurekaservice.client.util;

import com.netflix.appinfo.EurekaInstanceConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.zowe.apiml.config.ApiInfo;
import org.zowe.apiml.eurekaservice.client.config.ApiMediationServiceConfig;
import org.zowe.apiml.eurekaservice.client.config.ApimlEurekaInstanceConfig;
import org.zowe.apiml.eurekaservice.client.config.Authentication;
import org.zowe.apiml.eurekaservice.client.config.Catalog;
import org.zowe.apiml.eurekaservice.client.config.Route;
import org.zowe.apiml.eurekaservice.client.util.EurekaInstanceConfigValidator;
import org.zowe.apiml.eurekaservice.client.util.EurekaMetadataParser;
import org.zowe.apiml.exception.MetadataValidationException;
import org.zowe.apiml.exception.ServiceDefinitionException;
import org.zowe.apiml.util.MapUtils;
import org.zowe.apiml.util.UrlUtils;

public class EurekaInstanceConfigCreator {
    public EurekaInstanceConfig createEurekaInstanceConfig(ApiMediationServiceConfig config) throws ServiceDefinitionException {
        int port;
        String hostname;
        URL baseUrl;
        EurekaInstanceConfigValidator eurekaInstanceConfigValidator = new EurekaInstanceConfigValidator();
        eurekaInstanceConfigValidator.validate(config);
        ApimlEurekaInstanceConfig result = new ApimlEurekaInstanceConfig();
        try {
            baseUrl = new URL(config.getBaseUrl());
            hostname = baseUrl.getHost();
            port = baseUrl.getPort();
        }
        catch (MalformedURLException e) {
            String message = String.format("baseUrl: [%s] is not valid URL", config.getBaseUrl());
            throw new MetadataValidationException(message, (Throwable)e);
        }
        if (config.isPreferIpAddress()) {
            hostname = config.getServiceIpAddress();
            config.setBaseUrl(baseUrl.getProtocol() + "://" + hostname + ":" + port);
        }
        result.setInstanceId(String.format("%s:%s:%s", hostname, config.getServiceId(), port));
        result.setAppname(config.getServiceId());
        result.setAppGroupName(config.getServiceId());
        result.setHostName(hostname);
        result.setIpAddress(config.getServiceIpAddress());
        result.setInstanceEnabledOnit(true);
        result.setSecureVirtualHostName(config.getServiceId());
        result.setVirtualHostName(config.getServiceId());
        result.setStatusPageUrl(config.getBaseUrl() + config.getStatusPageRelativeUrl());
        if (config.getHomePageRelativeUrl() != null && !config.getHomePageRelativeUrl().isEmpty()) {
            result.setHomePageUrl(config.getBaseUrl() + config.getHomePageRelativeUrl());
        }
        String protocol = baseUrl.getProtocol();
        result.setNonSecurePort(port);
        switch (protocol) {
            case "http": {
                result.setNonSecurePortEnabled(true);
                result.setHealthCheckUrl(config.getBaseUrl() + config.getHealthCheckRelativeUrl());
                break;
            }
            case "https": {
                result.setSecurePort(port);
                result.setSecurePortEnabled(true);
                result.setSecureHealthCheckUrl(config.getBaseUrl() + config.getHealthCheckRelativeUrl());
                break;
            }
            default: {
                throw new MetadataValidationException(String.format("'%s' is not valid protocol for baseUrl property", protocol));
            }
        }
        try {
            result.setMetadataMap(this.createMetadata(config));
        }
        catch (IllegalArgumentException | MetadataValidationException e) {
            throw new ServiceDefinitionException("Service configuration failed to create service metadata: ", e);
        }
        return result;
    }

    private Map<String, String> createMetadata(ApiMediationServiceConfig config) {
        Catalog.Tile tile;
        HashMap<String, String> metadata = new HashMap<String, String>();
        Authentication authentication = config.getAuthentication();
        if (authentication != null) {
            metadata.put("apiml.authentication.scheme", authentication.getScheme());
            metadata.put("apiml.authentication.applid", authentication.getApplid());
            metadata.put("apiml.authentication.headers", authentication.getHeaders());
        }
        for (Route route : config.getRoutes()) {
            String gatewayUrl = UrlUtils.trimSlashes((String)route.getGatewayUrl());
            String serviceUrl = route.getServiceUrl();
            String key = gatewayUrl.replace("/", "-");
            metadata.put(String.format("%s.%s.%s", "apiml.routes", key, "gatewayUrl"), gatewayUrl);
            metadata.put(String.format("%s.%s.%s", "apiml.routes", key, "serviceUrl"), serviceUrl);
        }
        if (config.getCatalog() != null && (tile = config.getCatalog().getTile()) != null) {
            metadata.put("apiml.catalog.tile.id", tile.getId());
            metadata.put("apiml.catalog.tile.version", tile.getVersion());
            metadata.put("apiml.catalog.tile.title", tile.getTitle());
            metadata.put("apiml.catalog.tile.description", tile.getDescription());
        }
        metadata.put("apiml.service.title", config.getTitle());
        metadata.put("apiml.service.description", config.getDescription());
        metadata.putAll(this.flattenMetadata(config.getCustomMetadata()));
        for (ApiInfo apiInfo : config.getApiInfo()) {
            metadata.putAll(EurekaMetadataParser.generateMetadata((String)config.getServiceId(), (ApiInfo)apiInfo));
        }
        return metadata;
    }

    public Map<String, String> flattenMetadata(Map<String, Object> configurationMetadata) {
        return MapUtils.flattenMap(null, configurationMetadata);
    }
}

