/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.eurekaservice.client.impl;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import org.zowe.apiml.eurekaservice.client.ApiMediationClient;
import org.zowe.apiml.eurekaservice.client.EurekaClientConfigProvider;
import org.zowe.apiml.eurekaservice.client.EurekaClientProvider;
import org.zowe.apiml.eurekaservice.client.config.ApiMediationServiceConfig;
import org.zowe.apiml.eurekaservice.client.config.Ssl;
import org.zowe.apiml.eurekaservice.client.impl.ApiMlEurekaClientConfigProvider;
import org.zowe.apiml.eurekaservice.client.impl.DiscoveryClientProvider;
import org.zowe.apiml.eurekaservice.client.util.EurekaInstanceConfigCreator;
import org.zowe.apiml.exception.ServiceDefinitionException;
import org.zowe.apiml.security.HttpsConfig;
import org.zowe.apiml.security.HttpsFactory;

public class ApiMediationClientImpl
implements ApiMediationClient {
    private EurekaClientProvider eurekaClientProvider;
    private EurekaClientConfigProvider eurekaClientConfigProvider;
    private EurekaClient eurekaClient;
    private EurekaInstanceConfigCreator eurekaInstanceConfigCreator;

    public ApiMediationClientImpl() {
        this(new DiscoveryClientProvider());
    }

    public ApiMediationClientImpl(EurekaClientProvider eurekaClientProvider) {
        this(eurekaClientProvider, new ApiMlEurekaClientConfigProvider());
    }

    public ApiMediationClientImpl(EurekaClientProvider eurekaClientProvider, EurekaClientConfigProvider eurekaClientConfigProvider) {
        this(eurekaClientProvider, eurekaClientConfigProvider, new EurekaInstanceConfigCreator());
    }

    public ApiMediationClientImpl(EurekaClientProvider eurekaClientProvider, EurekaClientConfigProvider eurekaClientConfigProvider, EurekaInstanceConfigCreator instanceConfigCreator) {
        this.eurekaClientProvider = eurekaClientProvider;
        this.eurekaClientConfigProvider = eurekaClientConfigProvider;
        this.eurekaInstanceConfigCreator = instanceConfigCreator;
    }

    @Override
    public synchronized void register(ApiMediationServiceConfig config) throws ServiceDefinitionException {
        if (this.eurekaClient != null) {
            throw new ServiceDefinitionException("EurekaClient was previously registered for this instance of ApiMediationClient. Call your ApiMediationClient unregister() method before attempting other registration.");
        }
        EurekaClientConfig clientConfiguration = this.eurekaClientConfigProvider.config(config);
        ApplicationInfoManager infoManager = this.initializeApplicationInfoManager(config);
        this.eurekaClient = this.initializeEurekaClient(infoManager, clientConfiguration, config);
    }

    @Override
    public synchronized void unregister() {
        if (this.eurekaClient != null) {
            this.eurekaClient.shutdown();
        }
        this.eurekaClient = null;
    }

    private EurekaClient initializeEurekaClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig clientConfig, ApiMediationServiceConfig config) {
        Ssl sslConfig = config.getSsl();
        HttpsConfig.HttpsConfigBuilder builder = HttpsConfig.builder();
        if (sslConfig != null) {
            builder.protocol(sslConfig.getProtocol());
            if (Boolean.TRUE.equals(sslConfig.getEnabled())) {
                builder.keyAlias(sslConfig.getKeyAlias()).keyStore(sslConfig.getKeyStore()).keyPassword(sslConfig.getKeyPassword()).keyStorePassword(sslConfig.getKeyStorePassword()).keyStoreType(sslConfig.getKeyStoreType());
            }
            builder.verifySslCertificatesOfServices(Boolean.TRUE.equals(sslConfig.getVerifySslCertificatesOfServices()));
            if (Boolean.TRUE.equals(sslConfig.getVerifySslCertificatesOfServices())) {
                builder.trustStore(sslConfig.getTrustStore()).trustStoreType(sslConfig.getTrustStoreType()).trustStorePassword(sslConfig.getTrustStorePassword());
            }
        }
        HttpsConfig httpsConfig = builder.build();
        HttpsFactory factory = new HttpsFactory(httpsConfig);
        EurekaJerseyClient eurekaJerseyClient = factory.createEurekaJerseyClientBuilder(config.getDiscoveryServiceUrls().get(0), config.getServiceId()).build();
        DiscoveryClient.DiscoveryClientOptionalArgs args = new DiscoveryClient.DiscoveryClientOptionalArgs();
        args.setEurekaJerseyClient(eurekaJerseyClient);
        applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.UP);
        return this.eurekaClientProvider.client(applicationInfoManager, clientConfig, (AbstractDiscoveryClientOptionalArgs)args);
    }

    private ApplicationInfoManager initializeApplicationInfoManager(ApiMediationServiceConfig config) throws ServiceDefinitionException {
        EurekaInstanceConfig eurekaInstanceConfig = this.eurekaInstanceConfigCreator.createEurekaInstanceConfig(config);
        InstanceInfo instanceInformation = new EurekaConfigBasedInstanceInfoProvider(eurekaInstanceConfig).get();
        return new ApplicationInfoManager(eurekaInstanceConfig, instanceInformation);
    }

    @Override
    public EurekaClient getEurekaClient() {
        return this.eurekaClient;
    }
}

