/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.eurekaservice.client.util;

import com.google.common.primitives.Chars;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.eurekaservice.client.config.ApiMediationServiceConfig;
import org.zowe.apiml.eurekaservice.client.config.Route;
import org.zowe.apiml.eurekaservice.client.config.Ssl;
import org.zowe.apiml.exception.MetadataValidationException;

public class EurekaInstanceConfigValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EurekaInstanceConfigValidator.class);
    private static final String UNSET_VALUE_STRING = "{apiml.";
    private static final char[] UNSET_VALUE_CHAR_ARRAY = "{apiml.".toCharArray();
    private List<String> missingSslParameters = new ArrayList<String>();
    private List<String> missingRoutesParameters = new ArrayList<String>();

    public void validate(ApiMediationServiceConfig config) {
        this.validateRoutes(config.getRoutes());
        this.validateSsl(config.getSsl());
        if (config.getCatalog() == null) {
            log.warn("The API Catalog UI tile configuration is not provided. Try to add apiml.service.catalog.tile section.");
        }
        if (this.isInvalid(config.getHomePageRelativeUrl())) {
            log.warn("The home page URL is not provided. Try to add apiml.service.homePageRelativeUrl property or check its value.");
        }
        if (config.getApiInfo() == null || config.getApiInfo().isEmpty()) {
            log.warn("The API info configuration is not provided. Try to add apiml.service.apiInfo section.");
        }
    }

    private void validateRoutes(List<Route> routes) {
        if (routes == null || routes.isEmpty()) {
            throw new MetadataValidationException("Routes configuration was not provided. Try to add apiml.service.routes section.");
        }
        routes.forEach(route -> {
            if (this.isInvalid(route.getGatewayUrl())) {
                this.createListOfMissingRoutesParameters("gatewayUrl", this.missingRoutesParameters);
            }
            if (this.isInvalid(route.getServiceUrl())) {
                this.createListOfMissingRoutesParameters("serviceUrl", this.missingRoutesParameters);
            }
            if (!this.missingRoutesParameters.isEmpty()) {
                throw new MetadataValidationException(String.format("Routes parameters  ** %s ** are missing or were not replaced by the system properties.", String.join((CharSequence)", ", this.missingRoutesParameters)));
            }
        });
    }

    private void validateSsl(Ssl ssl) {
        if (ssl == null) {
            throw new MetadataValidationException("SSL configuration was not provided. Try add apiml.service.ssl section.");
        }
        if (this.isInvalid(ssl.getProtocol())) {
            this.createListOfMissingSslParameters("protocol", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getTrustStore())) {
            this.createListOfMissingSslParameters("trustStore", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getKeyStore())) {
            this.createListOfMissingSslParameters("keyStore", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getKeyAlias())) {
            this.createListOfMissingSslParameters("keyAlias", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getKeyStoreType())) {
            this.createListOfMissingSslParameters("keyStoreType", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getTrustStoreType())) {
            this.createListOfMissingSslParameters("trustStoreType", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getTrustStorePassword()) && (this.isInvalid(ssl.getTrustStoreType()) || !this.isInvalid(ssl.getTrustStoreType()) && !ssl.getTrustStoreType().equals("JCERACFKS"))) {
            this.createListOfMissingSslParameters("trustStorePassword", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getKeyStorePassword()) && (this.isInvalid(ssl.getKeyStoreType()) || !this.isInvalid(ssl.getKeyStoreType()) && !ssl.getKeyStoreType().equals("JCERACFKS"))) {
            this.createListOfMissingSslParameters("keyStorePassword", this.missingSslParameters);
        }
        if (this.isInvalid(ssl.getKeyPassword())) {
            this.createListOfMissingSslParameters("keyPassword", this.missingSslParameters);
        }
        if (ssl.getEnabled() == null) {
            this.createListOfMissingSslParameters("enabled", this.missingSslParameters);
        }
        if (!this.missingSslParameters.isEmpty()) {
            throw new MetadataValidationException(String.format("SSL parameters ** %s ** are missing or were not replaced by the system properties.", String.join((CharSequence)", ", this.missingSslParameters)));
        }
    }

    private boolean isInvalid(String value) {
        return value == null || value.isEmpty() || value.contains(UNSET_VALUE_STRING);
    }

    private boolean isInvalid(char[] value) {
        return value == null || value.length == 0 || Chars.indexOf((char[])value, (char[])UNSET_VALUE_CHAR_ARRAY) >= 0;
    }

    private void createListOfMissingSslParameters(String parameter, List parameters) {
        parameters.add(parameter);
    }

    private void createListOfMissingRoutesParameters(String parameter, List parameters) {
        parameters.add(parameter);
    }
}

