/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.enable.conditions;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.MultiValueMap;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Documented
@Conditional(value={OnMissingPropertyCondition.class})
public @interface ConditionalOnMissingProperty {
    public String[] value();

    @Order(value=-2147483608)
    public static class OnMissingPropertyCondition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            MultiValueMap annotationAttributes = metadata.getAllAnnotationAttributes(ConditionalOnMissingProperty.class.getName());
            if (!annotationAttributes.isEmpty()) {
                ConditionOutcome conditionOutcome = null;
                for (Object values : (List)annotationAttributes.get((Object)"value")) {
                    for (String propertyName : (String[])values) {
                        if (context.getEnvironment().containsProperty(propertyName)) {
                            conditionOutcome = this.checkPropertyValueForNullOrEmpty(context, propertyName);
                        }
                        if (conditionOutcome == null || conditionOutcome.isMatch()) continue;
                        return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.of((String)"At least one property with a value was found.", (Object[])new Object[0]));
                    }
                }
            }
            return ConditionOutcome.match((ConditionMessage)ConditionMessage.of((String)"None of the given properties found", (Object[])new Object[0]));
        }

        private ConditionOutcome checkPropertyValueForNullOrEmpty(ConditionContext context, String propertyName) {
            ConditionOutcome conditionOutcome;
            try {
                conditionOutcome = this.checkPropertyContentsForEmptyMatch(context, propertyName);
            }
            catch (Exception e) {
                conditionOutcome = ConditionOutcome.match((ConditionMessage)ConditionMessage.of((String)"Property found", (Object[])new Object[0]));
            }
            return conditionOutcome;
        }

        private ConditionOutcome checkPropertyContentsForEmptyMatch(ConditionContext context, String propertyName) {
            String propertyValue = context.getEnvironment().getProperty(propertyName, "");
            if (!propertyValue.isEmpty()) {
                return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.of((String)("Found property " + propertyName + " with value: " + propertyValue), (Object[])new Object[0]));
            }
            return ConditionOutcome.match((ConditionMessage)ConditionMessage.of((String)("Found property " + propertyName + " with an empty/null value"), (Object[])new Object[0]));
        }
    }
}

