/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.enable.services;

import io.swagger.models.Swagger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.zowe.apiml.enable.conditions.ConditionalOnMissingProperty;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

@Component
@ConditionalOnProperty(prefix="eureka.instance.metadata-map.mfaas.discovery", value={"enableApiDoc"}, havingValue="true", matchIfMissing=true)
@ConditionalOnMissingProperty(value={"eureka.instance.metadata-map.mfaas.api-info.swagger.location"})
public class LocalApiDocService {
    private final DocumentationCache documentationCache;
    private final JsonSerializer jsonSerializer;
    private final ServiceModelToSwagger2Mapper mapper;

    @Autowired
    public LocalApiDocService(DocumentationCache documentationCache, JsonSerializer jsonSerializer, ServiceModelToSwagger2Mapper mapper) {
        this.jsonSerializer = jsonSerializer;
        this.mapper = mapper;
        this.documentationCache = documentationCache;
    }

    public String getApiDoc(String apiDocGroup) {
        String groupName = Optional.ofNullable(apiDocGroup).orElse("default");
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            ArrayList entries = new ArrayList(this.documentationCache.all().entrySet());
            Collections.sort(entries, Comparator.comparing(o -> ((Documentation)o.getValue()).getGroupName()));
            Map.Entry firstEntry = (Map.Entry)entries.get(0);
            if (firstEntry == null) {
                return "Could not find group: " + groupName;
            }
            documentation = (Documentation)firstEntry.getValue();
        }
        Swagger apiDoc = this.mapper.mapDocumentation(documentation);
        Json json = this.jsonSerializer.toJson((Object)apiDoc);
        return json.value();
    }
}

