/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.enable.discovery;

import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.zowe.apiml.security.HttpsConfig;
import org.zowe.apiml.security.HttpsFactory;

@Configuration
public class EurekaClientSecurityConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EurekaClientSecurityConfiguration.class);
    @Value(value="${server.ssl.protocol:TLSv1.2}")
    private String protocol;
    @Value(value="${spring.application.name}")
    private String serviceId;
    @Value(value="${eureka.client.serviceUrl.defaultZone}")
    private String eurekaServerUrl;
    @Value(value="${server.ssl.trustStore:#{null}}")
    private String trustStore;
    @Value(value="${server.ssl.trustStorePassword:#{null}}")
    private String trustStorePassword;
    @Value(value="${server.ssl.trustStoreType:PKCS12}")
    private String trustStoreType;
    @Value(value="${server.ssl.keyAlias:#{null}}")
    private String keyAlias;
    @Value(value="${server.ssl.keyStore:#{null}}")
    private String keyStore;
    @Value(value="${server.ssl.keyPassword:#{null}}")
    private String keyPassword;
    @Value(value="${server.ssl.keyStorePassword:#{null}}")
    private String keyStorePassword;
    @Value(value="${server.ssl.keyStoreType:PKCS12}")
    private String keyStoreType;
    @Value(value="${apiml.security.ssl.verifySslCertificatesOfServices:true}")
    private boolean verifySslCertificatesOfServices;
    private EurekaJerseyClient eurekaJerseyClient;

    @PostConstruct
    public void init() {
        HttpsConfig httpsConfig = HttpsConfig.builder().keyAlias(this.keyAlias).protocol(this.protocol).keyStore(this.keyStore).keyPassword(this.keyPassword).keyStorePassword(this.keyStorePassword).keyStoreType(this.keyStoreType).trustStore(this.trustStore).trustStoreType(this.trustStoreType).trustStorePassword(this.trustStorePassword).verifySslCertificatesOfServices(this.verifySslCertificatesOfServices).build();
        log.info("Using HTTPS configuration: {}", (Object)httpsConfig.toString());
        HttpsFactory factory = new HttpsFactory(httpsConfig);
        this.eurekaJerseyClient = factory.createEurekaJerseyClientBuilder(this.eurekaServerUrl, this.serviceId).build();
    }

    @Bean
    public DiscoveryClient.DiscoveryClientOptionalArgs discoveryClientOptionalArgs() {
        DiscoveryClient.DiscoveryClientOptionalArgs args = new DiscoveryClient.DiscoveryClientOptionalArgs();
        args.setEurekaJerseyClient(this.eurekaJerseyClient);
        return args;
    }
}

