/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.registry.AbstractInstanceRegistry;
import com.netflix.eureka.registry.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.resources.ServerCodecs;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.cloud.netflix.eureka.server.InstanceRegistry;
import org.springframework.cloud.netflix.eureka.server.InstanceRegistryProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.zowe.apiml.discovery.EurekaStatusUpdateEvent;

public class ApimlInstanceRegistry
extends InstanceRegistry {
    private static final String EXCEPTION_MESSAGE = "Implementation of InstanceRegistry changed, please verify fix of order sending events";
    private MethodHandle handleRegistrationMethod;
    private MethodHandle handlerResolveInstanceLeaseDurationMethod;
    private MethodHandle handleCancelationMethod;
    private MethodHandle register2ArgsMethodHandle;
    private MethodHandle register3ArgsMethodHandle;
    private MethodHandle cancelMethodHandle;
    private ApplicationContext appCntx;

    public ApimlInstanceRegistry(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, EurekaClient eurekaClient, InstanceRegistryProperties instanceRegistryProperties, ApplicationContext appCntx) {
        super(serverConfig, clientConfig, serverCodecs, eurekaClient, instanceRegistryProperties.getExpectedNumberOfClientsSendingRenews(), instanceRegistryProperties.getDefaultOpenForTrafficCount());
        this.appCntx = appCntx;
        this.init();
    }

    private void init() {
        try {
            Method registrationMethod = InstanceRegistry.class.getDeclaredMethod("handleRegistration", InstanceInfo.class, Integer.TYPE, Boolean.TYPE);
            registrationMethod.setAccessible(true);
            this.handleRegistrationMethod = MethodHandles.lookup().unreflect(registrationMethod);
            Method cancelationMethod = InstanceRegistry.class.getDeclaredMethod("handleCancelation", String.class, String.class, Boolean.TYPE);
            cancelationMethod.setAccessible(true);
            this.handleCancelationMethod = MethodHandles.lookup().unreflect(cancelationMethod);
            Method resolveInstanceLeaseDurationMethod = InstanceRegistry.class.getDeclaredMethod("resolveInstanceLeaseDuration", InstanceInfo.class);
            resolveInstanceLeaseDurationMethod.setAccessible(true);
            this.handlerResolveInstanceLeaseDurationMethod = MethodHandles.lookup().unreflect(resolveInstanceLeaseDurationMethod);
            Constructor lookupConstructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            lookupConstructor.setAccessible(true);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)lookupConstructor.newInstance(PeerAwareInstanceRegistryImpl.class);
            this.register2ArgsMethodHandle = lookup.findSpecial(PeerAwareInstanceRegistryImpl.class, "register", MethodType.methodType(Void.TYPE, InstanceInfo.class, Boolean.TYPE), PeerAwareInstanceRegistryImpl.class);
            this.cancelMethodHandle = lookup.findSpecial(PeerAwareInstanceRegistryImpl.class, "cancel", MethodType.methodType(Boolean.TYPE, String.class, String.class, Boolean.TYPE), PeerAwareInstanceRegistryImpl.class);
            lookup = (MethodHandles.Lookup)lookupConstructor.newInstance(AbstractInstanceRegistry.class);
            this.register3ArgsMethodHandle = lookup.findSpecial(AbstractInstanceRegistry.class, "register", MethodType.methodType(Void.TYPE, InstanceInfo.class, Integer.TYPE, Boolean.TYPE), AbstractInstanceRegistry.class);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, e);
        }
    }

    protected int resolveInstanceLeaseDurationRewritten(InstanceInfo info) {
        try {
            return (Integer)this.handlerResolveInstanceLeaseDurationMethod.invokeWithArguments(new Object[]{this, info});
        }
        catch (ClassCastException | WrongMethodTypeException e) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, e);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, t);
        }
    }

    public void register(InstanceInfo info, int leaseDuration, boolean isReplication) {
        try {
            this.register3ArgsMethodHandle.invokeWithArguments(new Object[]{this, info, leaseDuration, isReplication});
            this.handleRegistrationMethod.invokeWithArguments(new Object[]{this, info, leaseDuration, isReplication});
        }
        catch (ClassCastException | WrongMethodTypeException e) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, e);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, t);
        }
    }

    public void register(InstanceInfo info, boolean isReplication) {
        try {
            this.register2ArgsMethodHandle.invokeWithArguments(new Object[]{this, info, isReplication});
            this.handleRegistrationMethod.invokeWithArguments(new Object[]{this, info, this.resolveInstanceLeaseDurationRewritten(info), isReplication});
        }
        catch (ClassCastException | WrongMethodTypeException e) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, e);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, t);
        }
    }

    public boolean cancel(String appName, String serverId, boolean isReplication) {
        try {
            boolean out = (Boolean)this.cancelMethodHandle.invokeWithArguments(new Object[]{this, appName, serverId, isReplication});
            this.handleCancelationMethod.invokeWithArguments(new Object[]{this, appName, serverId, isReplication});
            return out;
        }
        catch (ClassCastException | WrongMethodTypeException e) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, e);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE, t);
        }
    }

    public boolean statusUpdate(String appName, String instanceId, InstanceInfo.InstanceStatus newStatus, String lastDirtyTimestamp, boolean isReplication) {
        boolean isUpdated = super.statusUpdate(appName, instanceId, newStatus, lastDirtyTimestamp, isReplication);
        this.appCntx.publishEvent((ApplicationEvent)new EurekaStatusUpdateEvent((Object)this, appName, instanceId));
        return isUpdated;
    }
}

