/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.zowe.apiml.client.model.state.Existing;
import org.zowe.apiml.client.model.state.New;

@Schema(description="A Pet Object")
public class Pet {
    @Null(groups={New.class}, message="Id should be null for pet creation")
    @NotNull(groups={Existing.class}, message="Id should be not null for pet update")
    @Schema(description="The id is of the pet", example="1")
    private @Null(groups={New.class}, message="Id should be null for pet creation") @NotNull(groups={Existing.class}, message="Id should be not null for pet update") Long id;
    @NotEmpty(groups={New.class, Existing.class}, message="Name should not be empty string")
    @Schema(description="The name of the pet", example="Falco")
    private @NotEmpty(groups={New.class, Existing.class}, message="Name should not be empty string") String name;

    public Pet(@JsonProperty(value="id") Long id, @JsonProperty(value="name") String name) {
        this.id = id;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pet pet = (Pet)o;
        return Objects.equals(this.id, pet.id) && Objects.equals(this.name, pet.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }
}

