/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.api;

import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.zowe.apiml.client.model.Greeting;

@RestController
@Tag(name="Other Operations", description="General Operations")
@RequestMapping(value={"/api/v1"})
public class GreetingController {
    private static final String TEMPLATE = "Hello, %s!";

    @GetMapping(value={"/greeting"})
    @Operation(summary="Get a greeting", tags={"Other Operations"})
    @HystrixCommand
    public Greeting greeting(@RequestParam(value="name", defaultValue="world") String name, @RequestParam(value="delayMs", defaultValue="0", required=false) Integer delayMs) {
        if (delayMs > 0) {
            try {
                Thread.sleep(delayMs.intValue());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return new Greeting(new Date(), String.format(TEMPLATE, name));
    }

    @GetMapping(value={"/{yourName}/greeting"})
    @Operation(summary="Get a greeting", tags={"Other Operations"})
    @HystrixCommand
    public Greeting customGreeting(@PathVariable(value="yourName") String yourName) {
        return new Greeting(new Date(), String.format(TEMPLATE, yourName));
    }
}

