/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.api;

import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.zowe.apiml.passticket.IRRPassTicketEvaluationException;
import org.zowe.apiml.passticket.PassTicketService;

@RestController
@Tag(name="Test Operations")
public class PassTicketTestController {
    @Value(value="${apiml.service.applId:ZOWEAPPL}")
    private String defaultApplId;
    private final PassTicketService passTicketService;

    public PassTicketTestController(PassTicketService passTicketService) {
        this.passTicketService = passTicketService;
    }

    @GetMapping(value={"/api/v1/passticketTest"})
    @Operation(summary="Validate that the PassTicket in Authorization header is valid", tags={"Test Operations"})
    @HystrixCommand
    public void passticketTest(@RequestHeader(value="authorization") String authorization, @RequestHeader(value="X-Zowe-Auth-Failure", required=false) String zoweAuthFailure, @RequestParam(value="applId", defaultValue="", required=false) String applId) throws IRRPassTicketEvaluationException {
        if (authorization != null && authorization.toLowerCase().startsWith("basic")) {
            if (zoweAuthFailure != null) {
                throw new IllegalArgumentException("Scheme transformation happened and error was set in X-Zowe-Auth-Failure header");
            }
            String base64Credentials = authorization.substring("Basic".length()).trim();
            String credentials = new String(Base64.getDecoder().decode(base64Credentials), StandardCharsets.UTF_8);
            String[] values = credentials.split(":", 2);
            String userId = values[0];
            String passTicket = values[1];
            if (applId.isEmpty()) {
                applId = this.defaultApplId;
            }
            this.passTicketService.evaluate(userId, applId, passTicket);
        } else if (authorization != null && !authorization.toLowerCase().startsWith("basic") && zoweAuthFailure == null) {
            throw new IllegalArgumentException("Neither scheme transformation happened not error was set in X-Zowe-Auth-Failure header");
        }
    }
}

