/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.ws;

import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.zowe.apiml.client.ws.HeaderSocketServerHandler;
import org.zowe.apiml.client.ws.WebSocketServerHandler;
import org.zowe.apiml.message.core.MessageType;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.product.logging.annotations.InjectApimlLogger;

@Component
public class DiscoverableClientWebSocketConfigurer
implements WebSocketConfigurer {
    @InjectApimlLogger
    private final ApimlLogger logger = ApimlLogger.empty();

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        String webSocketEndpoint = "/ws/uppercase";
        this.logger.log("org.zowe.apiml.sampleservice.log.registeringWebSocket", new Object[]{webSocketEndpoint});
        registry.addHandler((WebSocketHandler)new WebSocketServerHandler(), new String[]{webSocketEndpoint}).setAllowedOrigins(new String[]{"*"});
        webSocketEndpoint = "/ws/header";
        this.logger.log(MessageType.DEBUG, "Registering WebSocket handler to {}", new Object[]{webSocketEndpoint});
        registry.addHandler((WebSocketHandler)new HeaderSocketServerHandler(), new String[]{webSocketEndpoint});
    }
}

