/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.api;

import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.zowe.apiml.client.model.RedirectLocation;

@RestController
@Tag(name="Other Operations")
public class PageRedirectionController {
    @PostMapping(value={"/api/v1/redirect"}, produces={"application/json"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.TEMPORARY_REDIRECT)
    @Operation(summary="/redirect", description="Redirect to location")
    @ApiResponses(value={@ApiResponse(responseCode="307", description="Redirect to specified location")})
    @HystrixCommand
    public RedirectLocation redirectPage(@Parameter(description="Location that need to be redirected to", required=true, example="https://host:port/context/path") @RequestBody RedirectLocation redirectLocation, HttpServletResponse response) {
        response.setHeader("Location", redirectLocation.getLocation());
        return redirectLocation;
    }
}

