/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.api;

import com.google.common.io.CharStreams;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/request"})
@Tag(description="/api/v1/request", name="The request info API")
public class RequestInfoController {
    @GetMapping(value={""}, produces={"application/json"})
    @Operation(summary="Returns all base information about request", description="Data contains sign information, headers and content")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information from request"), @ApiResponse(responseCode="500", description="Error in parsing of request ")})
    @ResponseBody
    @HystrixCommand
    public RequestInfo getRequestInfo(HttpServletRequest httpServletRequest) throws CertificateEncodingException, IOException {
        RequestInfo out = new RequestInfo();
        this.setCerts(httpServletRequest, out);
        this.setHeaders(httpServletRequest, out);
        this.setCookie(httpServletRequest, out);
        this.setContent(httpServletRequest, out);
        return out;
    }

    private void setCerts(HttpServletRequest httpServletRequest, RequestInfo requestInfo) throws CertificateEncodingException {
        X509Certificate[] certs = (X509Certificate[])httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null) {
            return;
        }
        requestInfo.signed = certs.length > 0;
        RequestInfo.access$102(requestInfo, new Certificate[certs.length]);
        for (int i = 0; i < certs.length; ++i) {
            Certificate certDto;
            X509Certificate cert = certs[i];
            ((RequestInfo)requestInfo).certs[i] = certDto = new Certificate(cert.getSerialNumber(), Base64.getEncoder().encodeToString(cert.getPublicKey().getEncoded()), Base64.getEncoder().encodeToString(cert.getEncoded()));
        }
    }

    private void setHeaders(HttpServletRequest httpServletRequest, RequestInfo requestInfo) {
        Enumeration e = httpServletRequest.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = httpServletRequest.getHeader(name);
            requestInfo.headers.put(name, value);
        }
    }

    private void setCookie(HttpServletRequest httpServletRequest, RequestInfo requestInfo) {
        if (httpServletRequest.getCookies() == null) {
            return;
        }
        for (Cookie cookie : httpServletRequest.getCookies()) {
            requestInfo.cookies.put(cookie.getName(), cookie.getValue());
        }
    }

    private void setContent(HttpServletRequest httpServletRequest, RequestInfo requestInfo) throws IOException {
        requestInfo.content = CharStreams.toString((Readable)httpServletRequest.getReader());
    }

    @Schema(description="Certificate info detail")
    public final class Certificate {
        private final BigInteger serialNo;
        private final String publicKeyEncodedBase64;
        private final String encodedBase64;

        @Generated
        public Certificate(BigInteger serialNo, String publicKeyEncodedBase64, String encodedBase64) {
            this.serialNo = serialNo;
            this.publicKeyEncodedBase64 = publicKeyEncodedBase64;
            this.encodedBase64 = encodedBase64;
        }

        @Generated
        public BigInteger getSerialNo() {
            return this.serialNo;
        }

        @Generated
        public String getPublicKeyEncodedBase64() {
            return this.publicKeyEncodedBase64;
        }

        @Generated
        public String getEncodedBase64() {
            return this.encodedBase64;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Certificate)) {
                return false;
            }
            Certificate other = (Certificate)o;
            BigInteger this$serialNo = this.getSerialNo();
            BigInteger other$serialNo = other.getSerialNo();
            if (this$serialNo == null ? other$serialNo != null : !((Object)this$serialNo).equals(other$serialNo)) {
                return false;
            }
            String this$publicKeyEncodedBase64 = this.getPublicKeyEncodedBase64();
            String other$publicKeyEncodedBase64 = other.getPublicKeyEncodedBase64();
            if (this$publicKeyEncodedBase64 == null ? other$publicKeyEncodedBase64 != null : !this$publicKeyEncodedBase64.equals(other$publicKeyEncodedBase64)) {
                return false;
            }
            String this$encodedBase64 = this.getEncodedBase64();
            String other$encodedBase64 = other.getEncodedBase64();
            return !(this$encodedBase64 == null ? other$encodedBase64 != null : !this$encodedBase64.equals(other$encodedBase64));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $serialNo = this.getSerialNo();
            result = result * 59 + ($serialNo == null ? 43 : ((Object)$serialNo).hashCode());
            String $publicKeyEncodedBase64 = this.getPublicKeyEncodedBase64();
            result = result * 59 + ($publicKeyEncodedBase64 == null ? 43 : $publicKeyEncodedBase64.hashCode());
            String $encodedBase64 = this.getEncodedBase64();
            result = result * 59 + ($encodedBase64 == null ? 43 : $encodedBase64.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RequestInfoController.Certificate(serialNo=" + this.getSerialNo() + ", publicKeyEncodedBase64=" + this.getPublicKeyEncodedBase64() + ", encodedBase64=" + this.getEncodedBase64() + ")";
        }
    }

    @Schema(description="Request info detail")
    public class RequestInfo {
        @Schema(description="Any certificate sign the request")
        private boolean signed;
        @Schema(description="Certificates used to sign the request")
        private Certificate[] certs;
        @Schema(description="Requests header in the original request")
        private Map<String, String> headers = new HashMap<String, String>();
        @Schema(description="Requests cookie in the original request")
        private Map<String, String> cookies = new HashMap<String, String>();
        @Schema(description="Text content in the original request")
        private String content;

        @Generated
        public boolean isSigned() {
            return this.signed;
        }

        @Generated
        public Certificate[] getCerts() {
            return this.certs;
        }

        @Generated
        public Map<String, String> getHeaders() {
            return this.headers;
        }

        @Generated
        public Map<String, String> getCookies() {
            return this.cookies;
        }

        @Generated
        public String getContent() {
            return this.content;
        }

        static /* synthetic */ Certificate[] access$102(RequestInfo x0, Certificate[] x1) {
            x0.certs = x1;
            return x1;
        }
    }
}

