/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;
import org.zowe.apiml.client.exception.PetNotFoundException;
import org.zowe.apiml.client.model.Pet;
import org.zowe.apiml.client.service.PetService;

@Service(value="petService")
public class PetServiceImpl
implements PetService {
    private final List<Pet> pets = new ArrayList<Pet>();
    private final AtomicLong counter = new AtomicLong(0L);

    @PostConstruct
    public void init() {
        this.pets.add(new Pet(this.counter.incrementAndGet(), "Falco"));
        this.pets.add(new Pet(this.counter.incrementAndGet(), "Jen\u00edk"));
        this.pets.add(new Pet(this.counter.incrementAndGet(), "Molly"));
        this.pets.add(new Pet(this.counter.incrementAndGet(), "Toby"));
    }

    @Override
    public Pet save(Pet pet) {
        pet.setId(this.counter.incrementAndGet());
        this.pets.add(pet);
        return pet;
    }

    @Override
    public Pet getById(Long id) {
        return this.pets.stream().filter(pet -> pet.getId().equals(id)).findFirst().orElse(null);
    }

    @Override
    public List<Pet> getAll() {
        return this.pets;
    }

    @Override
    public Pet update(Pet pet) {
        Pet petToUpdate = this.getById(pet.getId());
        if (petToUpdate == null) {
            return null;
        }
        int index = this.pets.indexOf(petToUpdate);
        this.pets.set(index, pet);
        return this.pets.get(index);
    }

    @Override
    public void deleteById(Long id) {
        if (!this.pets.removeIf(pet -> pet.getId().equals(id))) {
            throw new PetNotFoundException("Pet with provided id is not found", id);
        }
    }
}

