/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.api;

import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.zowe.apiml.client.model.Registered;
import org.zowe.apiml.client.service.ApiMediationClientService;
import org.zowe.apiml.exception.ServiceDefinitionException;

@RestController
@RequestMapping(value={"/api/v1/apiMediationClient"})
@Tag(description="/api/v1/apiMediationClient", name="API Mediation Client test call")
public class ApiMediationClientTestController {
    private final ApiMediationClientService apiMediationClientService;

    public ApiMediationClientTestController(ApiMediationClientService apiMediationClientService) {
        this.apiMediationClientService = apiMediationClientService;
    }

    @PostMapping
    @Operation(summary="Forward registration to discovery service via API mediation client")
    @HystrixCommand
    public ResponseEntity<String> forwardRegistration() {
        try {
            this.apiMediationClientService.register();
            return ResponseEntity.ok().build();
        }
        catch (ServiceDefinitionException e) {
            return ResponseEntity.status((int)500).body((Object)e.getMessage());
        }
    }

    @DeleteMapping
    @Operation(summary="Forward un-registration to discovery service via API mediation client")
    @HystrixCommand
    public ResponseEntity<String> forwardUnRegistration() {
        this.apiMediationClientService.unregister();
        return ResponseEntity.ok().build();
    }

    @GetMapping
    @Operation(summary="Indicate if registration with discovery service via API mediation client was successful")
    public Registered isRegistered() {
        boolean isRegistered = this.apiMediationClientService.isRegistered();
        return new Registered(isRegistered);
    }
}

