/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.api;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.zowe.apiml.client.api.PetController;
import org.zowe.apiml.client.exception.PetIdMismatchException;
import org.zowe.apiml.client.exception.PetNotFoundException;
import org.zowe.apiml.message.api.ApiMessageView;
import org.zowe.apiml.message.core.Message;
import org.zowe.apiml.message.core.MessageService;

@ControllerAdvice(assignableTypes={PetController.class})
@Order(value=-2147483648)
public class PetControllerExceptionHandler {
    private final MessageService messageService;

    @ExceptionHandler(value={PetNotFoundException.class})
    public ResponseEntity<ApiMessageView> handlePetNotFound(PetNotFoundException exception) {
        Message message = this.messageService.createMessage("org.zowe.apiml.sampleservice.api.petNotFound", new Object[]{exception.getId()});
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).contentType(MediaType.APPLICATION_JSON_UTF8).body((Object)message.mapToView());
    }

    @ExceptionHandler(value={PetIdMismatchException.class})
    public ResponseEntity<ApiMessageView> handleIdMismatch(PetIdMismatchException exception) {
        Message message = this.messageService.createMessage("org.zowe.apiml.sampleservice.api.petIdMismatchException", new Object[]{exception.getPathId(), exception.getBodyId()});
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON_UTF8).body((Object)message.mapToView());
    }

    @ExceptionHandler(value={TypeMismatchException.class})
    public ResponseEntity<ApiMessageView> handleIdTypeMismatch(TypeMismatchException exception) {
        Message message = this.messageService.createMessage("org.zowe.apiml.sampleservice.api.petIdTypeMismatch", new Object[]{exception.getValue()});
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON_UTF8).body((Object)message.mapToView());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ApiMessageView> handleMethodArgumentNotValid(MethodArgumentNotValidException exception) {
        List fieldErrors = exception.getBindingResult().getFieldErrors();
        ArrayList<Object[]> messages = new ArrayList<Object[]>();
        for (FieldError fieldError : fieldErrors) {
            Object[] messageFields = new Object[]{fieldError.getField(), fieldError.getRejectedValue(), fieldError.getDefaultMessage()};
            messages.add(messageFields);
        }
        List listApiMessage = this.messageService.createMessage("org.zowe.apiml.sampleservice.api.petMethodArgumentNotValid", messages).stream().map(Message::mapToApiMessage).collect(Collectors.toList());
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON_UTF8).body((Object)new ApiMessageView(listApiMessage));
    }

    @ExceptionHandler(value={UnrecognizedPropertyException.class})
    public ResponseEntity<ApiMessageView> handleUnrecognizedProperty(UnrecognizedPropertyException exception) {
        Message message = this.messageService.createMessage("org.zowe.apiml.sampleservice.api.petUnrecognizedProperty", new Object[]{exception.getPropertyName()});
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON_UTF8).body((Object)message.mapToView());
    }

    @ExceptionHandler(value={JsonParseException.class})
    public ResponseEntity<ApiMessageView> jsonParseException(JsonParseException exception) {
        Message message = this.messageService.createMessage("org.zowe.apiml.sampleservice.api.jsonParseException", new Object[]{exception.getMessage()});
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON_UTF8).body((Object)message.mapToView());
    }

    @ExceptionHandler(value={InvalidFormatException.class})
    public ResponseEntity<ApiMessageView> handleInvalidFormatException(InvalidFormatException exception) {
        String fieldName = ((JsonMappingException.Reference)exception.getPath().get(0)).getFieldName();
        Message message = this.messageService.createMessage("org.zowe.apiml.sampleservice.api.petInvalidFormatException", new Object[]{fieldName});
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON_UTF8).body((Object)message.mapToView());
    }

    @Generated
    public PetControllerExceptionHandler(MessageService messageService) {
        this.messageService = messageService;
    }
}

