/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.zowe.apiml.passticket.IRRPassTicketEvaluationException;
import org.zowe.apiml.passticket.PassTicketService;

@RestController
@Api(tags={"Test Operations"})
public class PassTicketTestController {
    @Value(value="${apiml.service.applId:ZOWEAPPL}")
    private String defaultApplId;
    private final PassTicketService passTicketService;

    public PassTicketTestController(PassTicketService passTicketService) {
        this.passTicketService = passTicketService;
    }

    @GetMapping(value={"/api/v1/passticketTest"})
    @ApiOperation(value="Validate that the PassTicket in Authorization header is valid", tags={"Test Operations"})
    public void passticketTest(@RequestHeader(value="authorization") String authorization, @RequestParam(value="applId", defaultValue="", required=false) String applId) throws IRRPassTicketEvaluationException {
        String passTicket;
        String userId;
        if (authorization != null && authorization.toLowerCase().startsWith("basic")) {
            String base64Credentials = authorization.substring("Basic".length()).trim();
            String credentials = new String(Base64.getDecoder().decode(base64Credentials), StandardCharsets.UTF_8);
            String[] values = credentials.split(":", 2);
            userId = values[0];
            passTicket = values[1];
            if (applId.isEmpty()) {
                applId = this.defaultApplId;
            }
        } else {
            throw new IllegalArgumentException("Missing Basic authorization header");
        }
        this.passTicketService.evaluate(userId, applId, passTicket);
    }
}

