/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.client.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.zowe.apiml.client.model.Registered;
import org.zowe.apiml.client.service.ApiMediationClientService;
import org.zowe.apiml.exception.ServiceDefinitionException;

@RestController
@RequestMapping(value={"/api/v1/apiMediationClient"})
@Api(value="/api/v1/apiMediationClient", tags={"API Mediation Client test call"})
public class ApiMediationClientTestController {
    private final ApiMediationClientService apiMediationClientService;

    public ApiMediationClientTestController(ApiMediationClientService apiMediationClientService) {
        this.apiMediationClientService = apiMediationClientService;
    }

    @PostMapping
    @ApiOperation(value="Forward registration to discovery service via API mediation client")
    public ResponseEntity<String> forwardRegistration() {
        try {
            this.apiMediationClientService.register();
            return ResponseEntity.ok().build();
        }
        catch (ServiceDefinitionException e) {
            return ResponseEntity.status((int)500).body((Object)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="Forward un-registration to discovery service via API mediation client")
    public ResponseEntity<String> forwardUnRegistration() {
        this.apiMediationClientService.unregister();
        return ResponseEntity.ok().build();
    }

    @GetMapping
    @ApiOperation(value="Indicate if registration with discovery service via API mediation client was successful")
    public Registered isRegistered() {
        boolean isRegistered = this.apiMediationClientService.isRegistered();
        return new Registered(isRegistered);
    }
}

