/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.config;

import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.zowe.apiml.caching.config.VsamConfig;
import org.zowe.apiml.caching.service.Storage;
import org.zowe.apiml.caching.service.inmemory.InMemoryStorage;
import org.zowe.apiml.caching.service.vsam.VsamStorage;

@Configuration
public class StorageConfiguration {
    private final VsamConfig vsamConfig;

    @ConditionalOnProperty(name={"caching.storage.mode"}, havingValue="vsam")
    @Bean
    public Storage vsam() {
        return new VsamStorage(this.vsamConfig);
    }

    @ConditionalOnMissingBean(value={Storage.class})
    @Bean
    public Storage inMemory() {
        return new InMemoryStorage();
    }

    @Generated
    public StorageConfiguration(VsamConfig vsamConfig) {
        this.vsamConfig = vsamConfig;
    }
}

